﻿;
; DTWAIN
;
; https:;github.com/dynarithmic/twain_library/tree/master
;


CompilerIf #PB_Compiler_IsMainFile
  EnableExplicit
CompilerEndIf


DeclareModule DTWAIN
  
  
  ;***************************************************************************
  ;* Generic Constants                                                       *
  ;***************************************************************************
  
  #TWON_ARRAY         = 3
  #TWON_ENUMERATION   = 4
  #TWON_ONEVALUE      = 5
  #TWON_RANGE         = 6
  
  #TWON_ICONID        = 962
  #TWON_DSMID         = 461
  #TWON_DSMCODEID     = 63
  
  #TWON_DONTCARE8       = $ff
  #TWON_DONTCARE16      = $ffff
  #TWON_DONTCARE32      = $ffffffff
  
  ; Flags used in TW_MEMORY Structure. 
  #TWMF_APPOWNS     = $0001
  #TWMF_DSMOWNS     = $0002
  #TWMF_DSOWNS      = $0004
  #TWMF_POINTER     = $0008
  #TWMF_HANDLE      = $0010
  
  #TWTY_INT8        = $0000
  #TWTY_INT16       = $0001
  #TWTY_INT32       = $0002
  
  #TWTY_UINT8       = $0003
  #TWTY_UINT16      = $0004
  #TWTY_UINT32      = $0005
  
  #TWTY_BOOL        = $0006
  
  #TWTY_FIX32       = $0007
  
  #TWTY_FRAME       = $0008
  
  #TWTY_STR32       = $0009
  #TWTY_STR64       = $000a
  #TWTY_STR128      = $000b
  #TWTY_STR255      = $000c
  #TWTY_HANDLE      = $000f
  
  
  ;***************************************************************************
  ;* Capability Constants                                                    *
  ;***************************************************************************
  
  ; CAP_ALARMS values 
  #TWAL_ALARM             = 0
  #TWAL_FEEDERERROR       = 1
  #TWAL_FEEDERWARNING     = 2
  #TWAL_BARCODE           = 3
  #TWAL_DOUBLEFEED        = 4
  #TWAL_JAM               = 5
  #TWAL_PATCHCODE         = 6
  #TWAL_POWER             = 7
  #TWAL_SKEW              = 8
  
  ; ICAP_AUTOSIZE values 
  #TWAS_NONE              = 0
  #TWAS_AUTO              = 1
  #TWAS_CURRENT           = 2
  
  ; TWEI_BARCODEROTATION values 
  #TWBCOR_ROT0            = 0
  #TWBCOR_ROT90           = 1
  #TWBCOR_ROT180          = 2
  #TWBCOR_ROT270          = 3
  #TWBCOR_ROTX            = 4
  
  ; ICAP_BARCODESEARCHMODE values 
  #TWBD_HORZ              = 0
  #TWBD_VERT              = 1
  #TWBD_HORZVERT          = 2
  #TWBD_VERTHORZ          = 3
  
  ; ICAP_BITORDER values 
  #TWBO_LSBFIRST          = 0
  #TWBO_MSBFIRST          = 1
  
  ; ICAP_AUTODISCARDBLANKPAGES values 
  #TWBP_DISABLE          = -2
  #TWBP_AUTO             = -1
  
  ; ICAP_BITDEPTHREDUCTION values 
  #TWBR_THRESHOLD         = 0
  #TWBR_HALFTONE          = 1
  #TWBR_CUSTHALFTONE      = 2
  #TWBR_DIFFUSION         = 3
  #TWBR_DYNAMICTHRESHOLD  = 4
  
  ; ICAP_SUPPORTEDBARCODETYPES And TWEI_BARCODETYPE values
  #TWBT_3OF9               = 0
  #TWBT_2OF5INTERLEAVED    = 1
  #TWBT_2OF5NONINTERLEAVED = 2
  #TWBT_CODE93             = 3
  #TWBT_CODE128            = 4
  #TWBT_UCC128             = 5
  #TWBT_CODABAR            = 6
  #TWBT_UPCA               = 7
  #TWBT_UPCE               = 8
  #TWBT_EAN8               = 9
  #TWBT_EAN13              = 10
  #TWBT_POSTNET            = 11
  #TWBT_PDF417             = 12
  #TWBT_2OF5INDUSTRIAL     = 13
  #TWBT_2OF5MATRIX         = 14
  #TWBT_2OF5DATALOGIC      = 15
  #TWBT_2OF5IATA           = 16
  #TWBT_3OF9FULLASCII      = 17
  #TWBT_CODABARWITHSTARTSTOP = 18
  #TWBT_MAXICODE           = 19
  #TWBT_QRCODE             = 20
  
  ; ICAP_COMPRESSION values
  #TWCP_NONE              = 0
  #TWCP_PACKBITS          = 1
  #TWCP_GROUP31D          = 2
  #TWCP_GROUP31DEOL       = 3
  #TWCP_GROUP32D          = 4
  #TWCP_GROUP4            = 5
  #TWCP_JPEG              = 6
  #TWCP_LZW               = 7
  #TWCP_JBIG              = 8
  #TWCP_PNG               = 9
  #TWCP_RLE4             = 10
  #TWCP_RLE8             = 11
  #TWCP_BITFIELDS        = 12
  #TWCP_ZIP              = 13
  #TWCP_JPEG2000         = 14
  
  ; CAP_CAMERASIDE And TWEI_PAGESIDE values 
  #TWCS_BOTH              = 0
  #TWCS_TOP               = 1
  #TWCS_BOTTOM            = 2
  
  ; CAP_DEVICEEVENT values 
  #TWDE_CUSTOMEVENTS           = $8000
  #TWDE_CHECKAUTOMATICCAPTURE= 0
  #TWDE_CHECKBATTERY         = 1
  #TWDE_CHECKDEVICEONLINE    = 2
  #TWDE_CHECKFLASH           = 3
  #TWDE_CHECKPOWERSUPPLY     = 4
  #TWDE_CHECKRESOLUTION      = 5
  #TWDE_DEVICEADDED          = 6
  #TWDE_DEVICEOFFLINE        = 7
  #TWDE_DEVICEREADY          = 8
  #TWDE_DEVICEREMOVED        = 9
  #TWDE_IMAGECAPTURED        = 10
  #TWDE_IMAGEDELETED         = 11
  #TWDE_PAPERDOUBLEFEED      = 12
  #TWDE_PAPERJAM             = 13
  #TWDE_LAMPFAILURE          = 14
  #TWDE_POWERSAVE            = 15
  #TWDE_POWERSAVENOTIFY      = 16
  
  ; TW_PASSTHRU.Direction values. 
  #TWDR_GET               = 1
  #TWDR_SET               = 2
  
  ; TWEI_DESKEWSTATUS values. 
  #TWDSK_SUCCESS          = 0
  #TWDSK_REPORTONLY       = 1
  #TWDSK_FAIL             = 2
  #TWDSK_DISABLED         = 3
  
  ; CAP_DUPLEX values 
  #TWDX_NONE              = 0
  #TWDX_1PASSDUPLEX       = 1
  #TWDX_2PASSDUPLEX       = 2
  
  ; CAP_FEEDERALIGNMENT values 
  #TWFA_NONE              = 0
  #TWFA_LEFT              = 1
  #TWFA_CENTER            = 2
  #TWFA_RIGHT             = 3
  
  ; ICAP_FEEDERTYPE values
  #TWFE_GENERAL           = 0
  #TWFE_PHOTO             = 1
  
  ; ICAP_IMAGEFILEFORMAT values 
  #TWFF_TIFF              = 0
  #TWFF_PICT              = 1
  #TWFF_BMP               = 2
  #TWFF_XBM               = 3
  #TWFF_JFIF              = 4
  #TWFF_FPX               = 5
  #TWFF_TIFFMULTI         = 6
  #TWFF_PNG               = 7
  #TWFF_SPIFF             = 8
  #TWFF_EXIF              = 9
  #TWFF_PDF              = 10
  #TWFF_JP2              = 11
  #TWFF_JPX              = 13
  #TWFF_DEJAVU           = 14
  #TWFF_PDFA             = 15
  #TWFF_PDFA2            = 16
  #TWFF_PDFRASTER        = 17
  
  ; ICAP_FLASHUSED2 values 
  #TWFL_NONE              = 0
  #TWFL_OFF               = 1
  #TWFL_ON                = 2
  #TWFL_AUTO              = 3
  #TWFL_REDEYE            = 4
  
  ; CAP_FEEDERORDER values 
  #TWFO_FIRSTPAGEFIRST    = 0
  #TWFO_LASTPAGEFIRST     = 1
  
  ; CAP_FEEDERPOCKET values
  #TWFP_POCKETERROR       = 0
  #TWFP_POCKET1           = 1
  #TWFP_POCKET2           = 2
  #TWFP_POCKET3           = 3
  #TWFP_POCKET4           = 4
  #TWFP_POCKET5           = 5
  #TWFP_POCKET6           = 6
  #TWFP_POCKET7           = 7
  #TWFP_POCKET8           = 8
  #TWFP_POCKET9           = 9
  #TWFP_POCKET10         = 10
  #TWFP_POCKET11         = 11
  #TWFP_POCKET12         = 12
  #TWFP_POCKET13         = 13
  #TWFP_POCKET14         = 14
  #TWFP_POCKET15         = 15
  #TWFP_POCKET16         = 16
  
  ; ICAP_FLIPROTATION values 
  #TWFR_BOOK              = 0
  #TWFR_FANFOLD           = 1
  
  ; ICAP_FILTER values 
  #TWFT_RED               = 0
  #TWFT_GREEN             = 1
  #TWFT_BLUE              = 2
  #TWFT_NONE              = 3
  #TWFT_WHITE             = 4
  #TWFT_CYAN              = 5
  #TWFT_MAGENTA           = 6
  #TWFT_YELLOW            = 7
  #TWFT_BLACK             = 8
  
  ; TW_FILESYSTEM.FileType values 
  #TWFY_CAMERA            = 0
  #TWFY_CAMERATOP         = 1
  #TWFY_CAMERABOTTOM      = 2
  #TWFY_CAMERAPREVIEW     = 3
  #TWFY_DOMAIN            = 4
  #TWFY_HOST              = 5
  #TWFY_DIRECTORY         = 6
  #TWFY_IMAGE             = 7
  #TWFY_UNKNOWN           = 8
  
  ; CAP_IAFIELD*_LEVEL values  
  #TWIA_UNUSED            = 0
  #TWIA_FIXED             = 1
  #TWIA_LEVEL1            = 2
  #TWIA_LEVEL2            = 3
  #TWIA_LEVEL3            = 4
  #TWIA_LEVEL4            = 5
  
  ; ICAP_ICCPROFILE values 
  #TWIC_NONE              = 0
  #TWIC_LINK              = 1
  #TWIC_EMBED             = 2
  
  ; ICAP_IMAGEFILTER values 
  #TWIF_NONE              = 0
  #TWIF_AUTO              = 1
  #TWIF_LOWPASS           = 2
  #TWIF_BANDPASS          = 3
  #TWIF_HIGHPASS          = 4
  #TWIF_TEXT              = #TWIF_BANDPASS
  #TWIF_FINELINE          = #TWIF_HIGHPASS
  
  ; ICAP_IMAGEMERGE values 
  #TWIM_NONE              = 0
  #TWIM_FRONTONTOP        = 1
  #TWIM_FRONTONBOTTOM     = 2
  #TWIM_FRONTONLEFT       = 3
  #TWIM_FRONTONRIGHT      = 4
  
  ; CAP_JOBCONTROL values  
  #TWJC_NONE              = 0
  #TWJC_JSIC              = 1
  #TWJC_JSIS              = 2
  #TWJC_JSXC              = 3
  #TWJC_JSXS              = 4
  
  ; ICAP_JPEGQUALITY values 
  #TWJQ_UNKNOWN          = -4
  #TWJQ_LOW              = -3
  #TWJQ_MEDIUM           = -2
  #TWJQ_HIGH             = -1
  
  ; ICAP_LIGHTPATH values 
  #TWLP_REFLECTIVE        = 0
  #TWLP_TRANSMISSIVE      = 1
  
  ; ICAP_LIGHTSOURCE values 
  #TWLS_RED               = 0
  #TWLS_GREEN             = 1
  #TWLS_BLUE              = 2
  #TWLS_NONE              = 3
  #TWLS_WHITE             = 4
  #TWLS_UV                = 5
  #TWLS_IR                = 6
  
  ; TWEI_MAGTYPE values 
  #TWMD_MICR              = 0
  #TWMD_RAW               = 1
  #TWMD_INVALID           = 2
  
  ; ICAP_NOISEFILTER values 
  #TWNF_NONE              = 0
  #TWNF_AUTO              = 1
  #TWNF_LONEPIXEL         = 2
  #TWNF_MAJORITYRULE      = 3
  
  ; ICAP_ORIENTATION values 
  #TWOR_ROT0              = 0
  #TWOR_ROT90             = 1
  #TWOR_ROT180            = 2
  #TWOR_ROT270            = 3
  #TWOR_PORTRAIT          = #TWOR_ROT0
  #TWOR_LANDSCAPE         = #TWOR_ROT270
  #TWOR_AUTO              = 4
  #TWOR_AUTOTEXT          = 5
  #TWOR_AUTOPICTURE       = 6
  
  ; ICAP_OVERSCAN values 
  #TWOV_NONE              = 0
  #TWOV_AUTO              = 1
  #TWOV_TOPBOTTOM         = 2
  #TWOV_LEFTRIGHT         = 3
  #TWOV_ALL               = 4
  
  ; Palette types For TW_PALETTE8 
  #TWPA_RGB       = 0
  #TWPA_GRAY      = 1
  #TWPA_CMY       = 2
  
  ; ICAP_PLANARCHUNKY values 
  #TWPC_CHUNKY            = 0
  #TWPC_PLANAR            = 1
  
  ; TWEI_PATCHCODE values
  #TWPCH_PATCH1           = 0
  #TWPCH_PATCH2           = 1
  #TWPCH_PATCH3           = 2
  #TWPCH_PATCH4           = 3
  #TWPCH_PATCH6           = 4
  #TWPCH_PATCHT           = 5
  
  ; ICAP_PIXELFLAVOR values 
  #TWPF_CHOCOLATE         = 0
  #TWPF_VANILLA           = 1
  
  ; CAP_PRINTERMODE values 
  #TWPM_SINGLESTRING      = 0
  #TWPM_MULTISTRING       = 1
  #TWPM_COMPOUNDSTRING    = 2
  #TWPM_IMAGEADDRESSSTRING= 3
  
  ; CAP_PRINTER values 
  #TWPR_IMPRINTERTOPBEFORE   = 0
  #TWPR_IMPRINTERTOPAFTER    = 1
  #TWPR_IMPRINTERBOTTOMBEFORE= 2
  #TWPR_IMPRINTERBOTTOMAFTER = 3
  #TWPR_ENDORSERTOPBEFORE    = 4
  #TWPR_ENDORSERTOPAFTER     = 5
  #TWPR_ENDORSERBOTTOMBEFORE = 6
  #TWPR_ENDORSERBOTTOMAFTER  = 7
  
  ; CAP_PRINTERFONTSTYLE Added 2.3 
  #TWPF_NORMAL            = 0
  #TWPF_BOLD              = 1
  #TWPF_ITALIC            = 2
  #TWPF_LARGESIZE         = 3
  #TWPF_SMALLSIZE         = 4
  
  ; CAP_PRINTERINDEXTRIGGER Added 2.3 
  #TWCT_PAGE              = 0
  #TWCT_PATCH1            = 1
  #TWCT_PATCH2            = 2
  #TWCT_PATCH3            = 3
  #TWCT_PATCH4            = 4
  #TWCT_PATCHT            = 5
  #TWCT_PATCH6            = 6
  
  ; CAP_POWERSUPPLY values 
  #TWPS_EXTERNAL          = 0
  #TWPS_BATTERY           = 1
  
  ; ICAP_PIXELTYPE values
  #TWPT_BW                = 0
  #TWPT_GRAY              = 1
  #TWPT_RGB               = 2
  #TWPT_PALETTE           = 3
  #TWPT_CMY               = 4
  #TWPT_CMYK              = 5
  #TWPT_YUV               = 6
  #TWPT_YUVK              = 7
  #TWPT_CIEXYZ            = 8
  #TWPT_LAB               = 9
  #TWPT_SRGB             = 10
  #TWPT_SCRGB            = 11
  #TWPT_INFRARED         = 16
  
  ; CAP_SEGMENTED values 
  #TWSG_NONE              = 0
  #TWSG_AUTO              = 1
  #TWSG_MANUAL            = 2
  
  ; ICAP_FILMTYPE values 
  #TWFM_POSITIVE          = 0
  #TWFM_NEGATIVE          = 1
  
  ; CAP_DOUBLEFEEDDETECTION 
  #TWDF_ULTRASONIC        = 0
  #TWDF_BYLENGTH          = 1
  #TWDF_INFRARED          = 2
  
  ; CAP_DOUBLEFEEDDETECTIONSENSITIVITY 
  #TWUS_LOW               = 0
  #TWUS_MEDIUM            = 1
  #TWUS_HIGH              = 2
  
  ; CAP_DOUBLEFEEDDETECTIONRESPONSE 
  #TWDP_STOP               = 0
  #TWDP_STOPANDWAIT        = 1
  #TWDP_SOUND              = 2
  #TWDP_DONOTIMPRINT       = 3
  
  ; ICAP_MIRROR values 
  #TWMR_NONE               = 0
  #TWMR_VERTICAL           = 1
  #TWMR_HORIZONTAL         = 2
  
  ; ICAP_JPEGSUBSAMPLING values 
  #TWJS_444YCBCR          = 0
  #TWJS_444RGB            = 1
  #TWJS_422               = 2
  #TWJS_421               = 3
  #TWJS_411               = 4
  #TWJS_420               = 5
  #TWJS_410               = 6
  #TWJS_311               = 7
  
  ; CAP_PAPERHANDLING values 
  #TWPH_NORMAL            = 0
  #TWPH_FRAGILE           = 1
  #TWPH_THICK             = 2
  #TWPH_TRIFOLD           = 3
  #TWPH_PHOTOGRAPH        = 4
  
  ; CAP_INDICATORSMODE values 
  #TWCI_INFO              = 0
  #TWCI_WARNING           = 1
  #TWCI_ERROR             = 2
  #TWCI_WARMUP            = 3
  
  ; ICAP_SUPPORTEDSIZES values (SS_ means Supported Sizes) 
  #TWSS_NONE              = 0
  #TWSS_A4                = 1
  #TWSS_JISB5             = 2
  #TWSS_USLETTER          = 3
  #TWSS_USLEGAL           = 4
  #TWSS_A5                = 5
  #TWSS_ISOB4             = 6
  #TWSS_ISOB6             = 7
  #TWSS_USLEDGER          = 9
  #TWSS_USEXECUTIVE      = 10
  #TWSS_A3               = 11
  #TWSS_ISOB3            = 12
  #TWSS_A6               = 13
  #TWSS_C4               = 14
  #TWSS_C5               = 15
  #TWSS_C6               = 16
  #TWSS_4A0              = 17
  #TWSS_2A0              = 18
  #TWSS_A0               = 19
  #TWSS_A1               = 20
  #TWSS_A2               = 21
  #TWSS_A7               = 22
  #TWSS_A8               = 23
  #TWSS_A9               = 24
  #TWSS_A10              = 25
  #TWSS_ISOB0            = 26
  #TWSS_ISOB1            = 27
  #TWSS_ISOB2            = 28
  #TWSS_ISOB5            = 29
  #TWSS_ISOB7            = 30
  #TWSS_ISOB8            = 31
  #TWSS_ISOB9            = 32
  #TWSS_ISOB10           = 33
  #TWSS_JISB0            = 34
  #TWSS_JISB1            = 35
  #TWSS_JISB2            = 36
  #TWSS_JISB3            = 37
  #TWSS_JISB4            = 38
  #TWSS_JISB6            = 39
  #TWSS_JISB7            = 40
  #TWSS_JISB8            = 41
  #TWSS_JISB9            = 42
  #TWSS_JISB10           = 43
  #TWSS_C0               = 44
  #TWSS_C1               = 45
  #TWSS_C2               = 46
  #TWSS_C3               = 47
  #TWSS_C7               = 48
  #TWSS_C8               = 49
  #TWSS_C9               = 50
  #TWSS_C10              = 51
  #TWSS_USSTATEMENT      = 52
  #TWSS_BUSINESSCARD     = 53
  #TWSS_MAXSIZE          = 54
  
  ; ICAP_XFERMECH values (SX_ means Setup XFer) 
  #TWSX_NATIVE            = 0
  #TWSX_FILE              = 1
  #TWSX_MEMORY            = 2
  #TWSX_MEMFILE           = 4
  
  ; ICAP_UNITS values (UN_ means UNits) 
  #TWUN_INCHES            = 0
  #TWUN_CENTIMETERS       = 1
  #TWUN_PICAS             = 2
  #TWUN_POINTS            = 3
  #TWUN_TWIPS             = 4
  #TWUN_PIXELS            = 5
  #TWUN_MILLIMETERS       = 6
  
  
  ;***************************************************************************
  ;* Country Constants                                                       *
  ;***************************************************************************
  
  #TWCY_AFGHANISTAN = 1001
  #TWCY_ALGERIA      = 213
  #TWCY_AMERICANSAMOA= 684
  #TWCY_ANDORRA       = 33
  #TWCY_ANGOLA      = 1002
  #TWCY_ANGUILLA    = 8090
  #TWCY_ANTIGUA     = 8091
  #TWCY_ARGENTINA     = 54
  #TWCY_ARUBA        = 297
  #TWCY_ASCENSIONI   = 247
  #TWCY_AUSTRALIA     = 61
  #TWCY_AUSTRIA       = 43
  #TWCY_BAHAMAS     = 8092
  #TWCY_BAHRAIN      = 973
  #TWCY_BANGLADESH   = 880
  #TWCY_BARBADOS    = 8093
  #TWCY_BELGIUM       = 32
  #TWCY_BELIZE       = 501
  #TWCY_BENIN        = 229
  #TWCY_BERMUDA     = 8094
  #TWCY_BHUTAN      = 1003
  #TWCY_BOLIVIA      = 591
  #TWCY_BOTSWANA     = 267
  #TWCY_BRITAIN        = 6
  #TWCY_BRITVIRGINIS= 8095
  #TWCY_BRAZIL        = 55
  #TWCY_BRUNEI       = 673
  #TWCY_BULGARIA     = 359
  #TWCY_BURKINAFASO = 1004
  #TWCY_BURMA       = 1005
  #TWCY_BURUNDI     = 1006
  #TWCY_CAMAROON     = 237
  #TWCY_CANADA         = 2
  #TWCY_CAPEVERDEIS  = 238
  #TWCY_CAYMANIS    = 8096
  #TWCY_CENTRALAFREP= 1007
  #TWCY_CHAD        = 1008
  #TWCY_CHILE         = 56
  #TWCY_CHINA         = 86
  #TWCY_CHRISTMASIS = 1009
  #TWCY_COCOSIS     = 1009
  #TWCY_COLOMBIA      = 57
  #TWCY_COMOROS     = 1010
  #TWCY_CONGO       = 1011
  #TWCY_COOKIS      = 1012
  #TWCY_COSTARICA    = 506
  #TWCY_CUBA           = 5
  #TWCY_CYPRUS       = 357
  #TWCY_CZECHOSLOVAKIA= 42
  #TWCY_DENMARK       = 45
  #TWCY_DJIBOUTI    = 1013
  #TWCY_DOMINICA    = 8097
  #TWCY_DOMINCANREP = 8098
  #TWCY_EASTERIS    = 1014
  #TWCY_ECUADOR      = 593
  #TWCY_EGYPT         = 20
  #TWCY_ELSALVADOR   = 503
  #TWCY_EQGUINEA    = 1015
  #TWCY_ETHIOPIA     = 251
  #TWCY_FALKLANDIS  = 1016
  #TWCY_FAEROEIS     = 298
  #TWCY_FIJIISLANDS  = 679
  #TWCY_FINLAND      = 358
  #TWCY_FRANCE        = 33
  #TWCY_FRANTILLES   = 596
  #TWCY_FRGUIANA     = 594
  #TWCY_FRPOLYNEISA  = 689
  #TWCY_FUTANAIS    = 1043
  #TWCY_GABON        = 241
  #TWCY_GAMBIA       = 220
  #TWCY_GERMANY       = 49
  #TWCY_GHANA        = 233
  #TWCY_GIBRALTER    = 350
  #TWCY_GREECE        = 30
  #TWCY_GREENLAND    = 299
  #TWCY_GRENADA     = 8099
  #TWCY_GRENEDINES  = 8015
  #TWCY_GUADELOUPE   = 590
  #TWCY_GUAM         = 671
  #TWCY_GUANTANAMOBAY = 5399
  #TWCY_GUATEMALA    = 502
  #TWCY_GUINEA       = 224
  #TWCY_GUINEABISSAU= 1017
  #TWCY_GUYANA       = 592
  #TWCY_HAITI        = 509
  #TWCY_HONDURAS     = 504
  #TWCY_HONGKONG     = 852
  #TWCY_HUNGARY       = 36
  #TWCY_ICELAND      = 354
  #TWCY_INDIA         = 91
  #TWCY_INDONESIA     = 62
  #TWCY_IRAN          = 98
  #TWCY_IRAQ         = 964
  #TWCY_IRELAND      = 353
  #TWCY_ISRAEL       = 972
  #TWCY_ITALY         = 39
  #TWCY_IVORYCOAST   = 225
  #TWCY_JAMAICA     = 8010
  #TWCY_JAPAN         = 81
  #TWCY_JORDAN       = 962
  #TWCY_KENYA        = 254
  #TWCY_KIRIBATI    = 1018
  #TWCY_KOREA         = 82
  #TWCY_KUWAIT       = 965
  #TWCY_LAOS        = 1019
  #TWCY_LEBANON     = 1020
  #TWCY_LIBERIA      = 231
  #TWCY_LIBYA        = 218
  #TWCY_LIECHTENSTEIN = 41
  #TWCY_LUXENBOURG   = 352
  #TWCY_MACAO        = 853
  #TWCY_MADAGASCAR  = 1021
  #TWCY_MALAWI       = 265
  #TWCY_MALAYSIA      = 60
  #TWCY_MALDIVES     = 960
  #TWCY_MALI        = 1022
  #TWCY_MALTA        = 356
  #TWCY_MARSHALLIS   = 692
  #TWCY_MAURITANIA  = 1023
  #TWCY_MAURITIUS    = 230
  #TWCY_MEXICO         = 3
  #TWCY_MICRONESIA   = 691
  #TWCY_MIQUELON     = 508
  #TWCY_MONACO        = 33
  #TWCY_MONGOLIA    = 1024
  #TWCY_MONTSERRAT  = 8011
  #TWCY_MOROCCO      = 212
  #TWCY_MOZAMBIQUE  = 1025
  #TWCY_NAMIBIA      = 264
  #TWCY_NAURU       = 1026
  #TWCY_NEPAL        = 977
  #TWCY_NETHERLANDS   = 31
  #TWCY_NETHANTILLES = 599
  #TWCY_NEVIS       = 8012
  #TWCY_NEWCALEDONIA = 687
  #TWCY_NEWZEALAND    = 64
  #TWCY_NICARAGUA    = 505
  #TWCY_NIGER        = 227
  #TWCY_NIGERIA      = 234
  #TWCY_NIUE        = 1027
  #TWCY_NORFOLKI    = 1028
  #TWCY_NORWAY        = 47
  #TWCY_OMAN         = 968
  #TWCY_PAKISTAN      = 92
  #TWCY_PALAU       = 1029
  #TWCY_PANAMA       = 507
  #TWCY_PARAGUAY     = 595
  #TWCY_PERU          = 51
  #TWCY_PHILLIPPINES  = 63
  #TWCY_PITCAIRNIS  = 1030
  #TWCY_PNEWGUINEA   = 675
  #TWCY_POLAND        = 48
  #TWCY_PORTUGAL     = 351
  #TWCY_QATAR        = 974
  #TWCY_REUNIONI    = 1031
  #TWCY_ROMANIA       = 40
  #TWCY_RWANDA       = 250
  #TWCY_SAIPAN       = 670
  #TWCY_SANMARINO     = 39
  #TWCY_SAOTOME     = 1033
  #TWCY_SAUDIARABIA  = 966
  #TWCY_SENEGAL      = 221
  #TWCY_SEYCHELLESIS= 1034
  #TWCY_SIERRALEONE = 1035
  #TWCY_SINGAPORE     = 65
  #TWCY_SOLOMONIS   = 1036
  #TWCY_SOMALI      = 1037
  #TWCY_SOUTHAFRICA   = 27
  #TWCY_SPAIN         = 34
  #TWCY_SRILANKA      = 94
  #TWCY_STHELENA    = 1032
  #TWCY_STKITTS     = 8013
  #TWCY_STLUCIA     = 8014
  #TWCY_STPIERRE     = 508
  #TWCY_STVINCENT   = 8015
  #TWCY_SUDAN       = 1038
  #TWCY_SURINAME     = 597
  #TWCY_SWAZILAND    = 268
  #TWCY_SWEDEN        = 46
  #TWCY_SWITZERLAND   = 41
  #TWCY_SYRIA       = 1039
  #TWCY_TAIWAN       = 886
  #TWCY_TANZANIA     = 255
  #TWCY_THAILAND      = 66
  #TWCY_TOBAGO      = 8016
  #TWCY_TOGO         = 228
  #TWCY_TONGAIS      = 676
  #TWCY_TRINIDAD    = 8016
  #TWCY_TUNISIA      = 216
  #TWCY_TURKEY        = 90
  #TWCY_TURKSCAICOS = 8017
  #TWCY_TUVALU      = 1040
  #TWCY_UGANDA       = 256
  #TWCY_USSR           = 7
  #TWCY_UAEMIRATES   = 971
  #TWCY_UNITEDKINGDOM = 44
  #TWCY_USA            = 1
  #TWCY_URUGUAY      = 598
  #TWCY_VANUATU     = 1041
  #TWCY_VATICANCITY   = 39
  #TWCY_VENEZUELA     = 58
  #TWCY_WAKE        = 1042
  #TWCY_WALLISIS    = 1043
  #TWCY_WESTERNSAHARA = 1044
  #TWCY_WESTERNSAMOA= 1045
  #TWCY_YEMEN       = 1046
  #TWCY_YUGOSLAVIA    = 38
  #TWCY_ZAIRE        = 243
  #TWCY_ZAMBIA       = 260
  #TWCY_ZIMBABWE     = 263
  #TWCY_ALBANIA      = 355
  #TWCY_ARMENIA      = 374
  #TWCY_AZERBAIJAN   = 994
  #TWCY_BELARUS      = 375
  #TWCY_BOSNIAHERZGO = 387
  #TWCY_CAMBODIA     = 855
  #TWCY_CROATIA      = 385
  #TWCY_CZECHREPUBLIC= 420
  #TWCY_DIEGOGARCIA  = 246
  #TWCY_ERITREA      = 291
  #TWCY_ESTONIA      = 372
  #TWCY_GEORGIA      = 995
  #TWCY_LATVIA       = 371
  #TWCY_LESOTHO      = 266
  #TWCY_LITHUANIA    = 370
  #TWCY_MACEDONIA    = 389
  #TWCY_MAYOTTEIS    = 269
  #TWCY_MOLDOVA      = 373
  #TWCY_MYANMAR       = 95
  #TWCY_NORTHKOREA   = 850
  #TWCY_PUERTORICO   = 787
  #TWCY_RUSSIA         = 7
  #TWCY_SERBIA       = 381
  #TWCY_SLOVAKIA     = 421
  #TWCY_SLOVENIA     = 386
  #TWCY_SOUTHKOREA    = 82
  #TWCY_UKRAINE      = 380
  #TWCY_USVIRGINIS   = 340
  #TWCY_VIETNAM       = 84
  
  ;***************************************************************************
  ;* Language Constants                                                      *
  ;***************************************************************************
  #TWLG_USERLOCALE         = -1
  #TWLG_DAN                 = 0
  #TWLG_DUT                 = 1
  #TWLG_ENG                 = 2
  #TWLG_FCF                 = 3
  #TWLG_FIN                 = 4
  #TWLG_FRN                 = 5
  #TWLG_GER                 = 6
  #TWLG_ICE                 = 7
  #TWLG_ITN                 = 8
  #TWLG_NOR                 = 9
  #TWLG_POR                 = 10
  #TWLG_SPA                 = 11
  #TWLG_SWE                 = 12
  #TWLG_USA                 = 13
  #TWLG_AFRIKAANS           = 14
  #TWLG_ALBANIA             = 15
  #TWLG_ARABIC              = 16
  #TWLG_ARABIC_ALGERIA      = 17
  #TWLG_ARABIC_BAHRAIN      = 18
  #TWLG_ARABIC_EGYPT        = 19
  #TWLG_ARABIC_IRAQ         = 20
  #TWLG_ARABIC_JORDAN       = 21
  #TWLG_ARABIC_KUWAIT       = 22
  #TWLG_ARABIC_LEBANON      = 23
  #TWLG_ARABIC_LIBYA        = 24
  #TWLG_ARABIC_MOROCCO      = 25
  #TWLG_ARABIC_OMAN         = 26
  #TWLG_ARABIC_QATAR        = 27
  #TWLG_ARABIC_SAUDIARABIA  = 28
  #TWLG_ARABIC_SYRIA        = 29
  #TWLG_ARABIC_TUNISIA      = 30
  #TWLG_ARABIC_UAE          = 31
  #TWLG_ARABIC_YEMEN        = 32
  #TWLG_BASQUE              = 33
  #TWLG_BYELORUSSIAN        = 34
  #TWLG_BULGARIAN           = 35
  #TWLG_CATALAN             = 36
  #TWLG_CHINESE             = 37
  #TWLG_CHINESE_HONGKONG    = 38
  #TWLG_CHINESE_PRC         = 39
  #TWLG_CHINESE_SINGAPORE   = 40
  #TWLG_CHINESE_SIMPLIFIED  = 41
  #TWLG_CHINESE_TAIWAN      = 42
  #TWLG_CHINESE_TRADITIONAL = 43
  #TWLG_CROATIA             = 44
  #TWLG_CZECH               = 45
  #TWLG_DANISH              = #TWLG_DAN
  #TWLG_DUTCH               = #TWLG_DUT
  #TWLG_DUTCH_BELGIAN       = 46
  #TWLG_ENGLISH             = #TWLG_ENG
  #TWLG_ENGLISH_AUSTRALIAN  = 47
  #TWLG_ENGLISH_CANADIAN    = 48
  #TWLG_ENGLISH_IRELAND     = 49
  #TWLG_ENGLISH_NEWZEALAND  = 50
  #TWLG_ENGLISH_SOUTHAFRICA = 51
  #TWLG_ENGLISH_UK          = 52
  #TWLG_ENGLISH_USA         = #TWLG_USA
  #TWLG_ESTONIAN            = 53
  #TWLG_FAEROESE            = 54
  #TWLG_FARSI               = 55
  #TWLG_FINNISH             = #TWLG_FIN
  #TWLG_FRENCH              = #TWLG_FRN
  #TWLG_FRENCH_BELGIAN      = 56
  #TWLG_FRENCH_CANADIAN     = #TWLG_FCF
  #TWLG_FRENCH_LUXEMBOURG   = 57
  #TWLG_FRENCH_SWISS        = 58
  #TWLG_GERMAN              = #TWLG_GER
  #TWLG_GERMAN_AUSTRIAN     = 59
  #TWLG_GERMAN_LUXEMBOURG   = 60
  #TWLG_GERMAN_LIECHTENSTEIN= 61
  #TWLG_GERMAN_SWISS        = 62
  #TWLG_GREEK               = 63
  #TWLG_HEBREW              = 64
  #TWLG_HUNGARIAN           = 65
  #TWLG_ICELANDIC           = #TWLG_ICE
  #TWLG_INDONESIAN          = 66
  #TWLG_ITALIAN             = #TWLG_ITN
  #TWLG_ITALIAN_SWISS       = 67
  #TWLG_JAPANESE            = 68
  #TWLG_KOREAN              = 69
  #TWLG_KOREAN_JOHAB        = 70
  #TWLG_LATVIAN             = 71
  #TWLG_LITHUANIAN          = 72
  #TWLG_NORWEGIAN           = #TWLG_NOR
  #TWLG_NORWEGIAN_BOKMAL    = 73
  #TWLG_NORWEGIAN_NYNORSK   = 74
  #TWLG_POLISH              = 75
  #TWLG_PORTUGUESE          = #TWLG_POR
  #TWLG_PORTUGUESE_BRAZIL   = 76
  #TWLG_ROMANIAN            = 77
  #TWLG_RUSSIAN             = 78
  #TWLG_SERBIAN_LATIN       = 79
  #TWLG_SLOVAK              = 80
  #TWLG_SLOVENIAN           = 81
  #TWLG_SPANISH             = #TWLG_SPA
  #TWLG_SPANISH_MEXICAN     = 82
  #TWLG_SPANISH_MODERN      = 83
  #TWLG_SWEDISH             = #TWLG_SWE
  #TWLG_THAI                = 84
  #TWLG_TURKISH             = 85
  #TWLG_UKRANIAN            = 86
  #TWLG_ASSAMESE            = 87
  #TWLG_BENGALI             = 88
  #TWLG_BIHARI              = 89
  #TWLG_BODO                = 90
  #TWLG_DOGRI               = 91
  #TWLG_GUJARATI            = 92
  #TWLG_HARYANVI            = 93
  #TWLG_HINDI               = 94
  #TWLG_KANNADA             = 95
  #TWLG_KASHMIRI            = 96
  #TWLG_MALAYALAM           = 97
  #TWLG_MARATHI             = 98
  #TWLG_MARWARI             = 99
  #TWLG_MEGHALAYAN          = 100
  #TWLG_MIZO                = 101
  #TWLG_NAGA                = 102
  #TWLG_ORISSI              = 103
  #TWLG_PUNJABI             = 104
  #TWLG_PUSHTU              = 105
  #TWLG_SERBIAN_CYRILLIC    = 106
  #TWLG_SIKKIMI             = 107
  #TWLG_SWEDISH_FINLAND     = 108
  #TWLG_TAMIL               = 109
  #TWLG_TELUGU              = 110
  #TWLG_TRIPURI             = 111
  #TWLG_URDU                = 112
  #TWLG_VIETNAMESE          = 113
  
  
  ;***************************************************************************
  ;* Data Groups                                                             *
  ;***************************************************************************
  #DG_CONTROL          = $0001
  #DG_IMAGE            = $0002
  #DG_AUDIO            = $0004
  
  ; More Data Functionality may be added in the future.
  ; These are For items that need To be determined before DS is opened.
  ; NOTE: Supported Functionality constants must be powers of 2 As they are
  ;       used As bitflags when Application asks DSM To present a List of DSs.
  ;       To support backward capability the App And DS will Not use the fields
  #DF_DSM2             = $10000000
  #DF_APP2             = $20000000
  
  #DF_DS2              = $40000000
  
  #DG_MASK             = $FFFF
  
  ;**********************************************************
  ;*                                                        *
  ;**********************************************************
  #DAT_NULL            = $0000
  #DAT_CUSTOMBASE      = $8000
  
  ; Data Argument Types For the DG_CONTROL Data Group.
  #DAT_CAPABILITY      = $0001
  #DAT_EVENT           = $0002
  #DAT_IDENTITY        = $0003
  #DAT_PARENT          = $0004
  #DAT_PENDINGXFERS    = $0005
  #DAT_SETUPMEMXFER    = $0006
  #DAT_SETUPFILEXFER   = $0007
  #DAT_STATUS          = $0008
  #DAT_USERINTERFACE   = $0009
  #DAT_XFERGROUP       = $000a
  #DAT_CUSTOMDSDATA    = $000c
  #DAT_DEVICEEVENT     = $000d
  #DAT_FILESYSTEM      = $000e
  #DAT_PASSTHRU        = $000f
  #DAT_CALLBACK        = $0010
  #DAT_STATUSUTF8      = $0011
  #DAT_CALLBACK2       = $0012
  #DAT_METRICS         = $0013
  #DAT_TWAINDIRECT     = $0014
  
  ; Data Argument Types For the DG_IMAGE Data Group. 
  #DAT_IMAGEINFO       = $0101
  #DAT_IMAGELAYOUT     = $0102
  #DAT_IMAGEMEMXFER    = $0103
  #DAT_IMAGENATIVEXFER = $0104
  #DAT_IMAGEFILEXFER   = $0105
  #DAT_CIECOLOR        = $0106
  #DAT_GRAYRESPONSE    = $0107
  #DAT_RGBRESPONSE     = $0108
  #DAT_JPEGCOMPRESSION = $0109
  #DAT_PALETTE8        = $010a
  #DAT_EXTIMAGEINFO    = $010b
  #DAT_FILTER          = $010c
  
  ; Data Argument Types For the DG_AUDIO Data Group. 
  #DAT_AUDIOFILEXFER   = $0201
  #DAT_AUDIOINFO       = $0202
  #DAT_AUDIONATIVEXFER = $0203
  
  ; misplaced 
  #DAT_ICCPROFILE        = $0401
  #DAT_IMAGEMEMFILEXFER  = $0402
  #DAT_ENTRYPOINT        = $0403
  
  
  ;***************************************************************************
  ;* Messages                                                                *
  ;***************************************************************************
  
  ; All message constants are unique.
  ; Messages are grouped according To which DATs they are used With.
  
  #MSG_NULL            = $0000
  #MSG_CUSTOMBASE      = $8000
  
  ; Generic messages may be used With any of several DATs.
  #MSG_GET             = $0001
  #MSG_GETCURRENT      = $0002
  #MSG_GETDEFAULT      = $0003
  #MSG_GETFIRST        = $0004
  #MSG_GETNEXT         = $0005
  #MSG_SET             = $0006
  #MSG_RESET           = $0007
  #MSG_QUERYSUPPORT    = $0008
  #MSG_GETHELP         = $0009
  #MSG_GETLABEL        = $000a
  #MSG_GETLABELENUM    = $000b
  #MSG_SETCONSTRAINT   = $000c
  
  ; Messages used With DAT_NULL
  #MSG_XFERREADY    = $0101
  #MSG_CLOSEDSREQ   = $0102
  #MSG_CLOSEDSOK    = $0103
  #MSG_DEVICEEVENT  = $0104
  
  ; Messages used With a pointer To DAT_PARENT Data
  #MSG_OPENDSM      = $0301
  #MSG_CLOSEDSM     = $0302
  
  ; Messages used With a pointer To a DAT_IDENTITY Structure
  #MSG_OPENDS       = $0401
  #MSG_CLOSEDS      = $0402
  #MSG_USERSELECT   = $0403
  
  ; Messages used With a pointer To a DAT_USERINTERFACE Structure
  #MSG_DISABLEDS    = $0501
  #MSG_ENABLEDS     = $0502
  #MSG_ENABLEDSUIONLY  = $0503
  
  ; Messages used With a pointer To a DAT_EVENT Structure
  #MSG_PROCESSEVENT = $0601
  
  ; Messages used With a pointer To a DAT_PENDINGXFERS Structure
  #MSG_ENDXFER      = $0701
  #MSG_STOPFEEDER   = $0702
  
  ; Messages used With a pointer To a DAT_FILESYSTEM Structure
  #MSG_CHANGEDIRECTORY   = $0801
  #MSG_CREATEDIRECTORY   = $0802
  #MSG_DELETE            = $0803
  #MSG_FORMATMEDIA       = $0804
  #MSG_GETCLOSE          = $0805
  #MSG_GETFIRSTFILE      = $0806
  #MSG_GETINFO           = $0807
  #MSG_GETNEXTFILE       = $0808
  #MSG_RENAME            = $0809
  #MSG_COPY              = $080A
  #MSG_AUTOMATICCAPTUREDIRECTORY = $080B
  
  ; Messages used With a pointer To a DAT_PASSTHRU Structure
  #MSG_PASSTHRU          = $0901
  
  ; used With DAT_CALLBACK
  #MSG_REGISTER_CALLBACK = $0902
  
  ; used With DAT_CAPABILITY
  #MSG_RESETALL          = $0A01
  
  ; used With DAT_TWAINDIRECT
  #MSG_SETTASK           = $0B01
  
  ;***************************************************************************
  ;* Capabilities                                                            *
  ;***************************************************************************
  
  #CAP_CUSTOMBASE          = $8000 ; Base of custom capabilities 
  
  ; all Data sources are REQUIRED To support these caps 
  #CAP_XFERCOUNT           = $0001
  
  ; image Data sources are REQUIRED To support these caps 
  #ICAP_COMPRESSION        = $0100
  #ICAP_PIXELTYPE          = $0101
  #ICAP_UNITS              = $0102
  #ICAP_XFERMECH           = $0103
  
  ; all Data sources MAY support these caps 
  #CAP_AUTHOR                  = $1000
  #CAP_CAPTION                 = $1001
  #CAP_FEEDERENABLED           = $1002
  #CAP_FEEDERLOADED            = $1003
  #CAP_TIMEDATE                = $1004
  #CAP_SUPPORTEDCAPS           = $1005
  #CAP_EXTENDEDCAPS            = $1006
  #CAP_AUTOFEED                = $1007
  #CAP_CLEARPAGE               = $1008
  #CAP_FEEDPAGE                = $1009
  #CAP_REWINDPAGE              = $100a
  #CAP_INDICATORS              = $100b
  #CAP_PAPERDETECTABLE         = $100d
  #CAP_UICONTROLLABLE          = $100e
  #CAP_DEVICEONLINE            = $100f
  #CAP_AUTOSCAN                = $1010
  #CAP_THUMBNAILSENABLED       = $1011
  #CAP_DUPLEX                  = $1012
  #CAP_DUPLEXENABLED           = $1013
  #CAP_ENABLEDSUIONLY          = $1014
  #CAP_CUSTOMDSDATA            = $1015
  #CAP_ENDORSER                = $1016
  #CAP_JOBCONTROL              = $1017
  #CAP_ALARMS                  = $1018
  #CAP_ALARMVOLUME             = $1019
  #CAP_AUTOMATICCAPTURE        = $101a
  #CAP_TIMEBEFOREFIRSTCAPTURE  = $101b
  #CAP_TIMEBETWEENCAPTURES     = $101c
  #CAP_MAXBATCHBUFFERS         = $101e
  #CAP_DEVICETIMEDATE          = $101f
  #CAP_POWERSUPPLY             = $1020
  #CAP_CAMERAPREVIEWUI         = $1021
  #CAP_DEVICEEVENT             = $1022
  #CAP_SERIALNUMBER            = $1024
  #CAP_PRINTER                 = $1026
  #CAP_PRINTERENABLED          = $1027
  #CAP_PRINTERINDEX            = $1028
  #CAP_PRINTERMODE             = $1029
  #CAP_PRINTERSTRING           = $102a
  #CAP_PRINTERSUFFIX           = $102b
  #CAP_LANGUAGE                = $102c
  #CAP_FEEDERALIGNMENT         = $102d
  #CAP_FEEDERORDER             = $102e
  #CAP_REACQUIREALLOWED        = $1030
  #CAP_BATTERYMINUTES          = $1032
  #CAP_BATTERYPERCENTAGE       = $1033
  #CAP_CAMERASIDE              = $1034
  #CAP_SEGMENTED               = $1035
  #CAP_CAMERAENABLED           = $1036
  #CAP_CAMERAORDER             = $1037
  #CAP_MICRENABLED             = $1038
  #CAP_FEEDERPREP              = $1039
  #CAP_FEEDERPOCKET            = $103a
  #CAP_AUTOMATICSENSEMEDIUM    = $103b
  #CAP_CUSTOMINTERFACEGUID     = $103c
  #CAP_SUPPORTEDCAPSSEGMENTUNIQUE    = $103d
  #CAP_SUPPORTEDDATS           = $103e
  #CAP_DOUBLEFEEDDETECTION     = $103f
  #CAP_DOUBLEFEEDDETECTIONLENGTH = $1040
  #CAP_DOUBLEFEEDDETECTIONSENSITIVITY = $1041
  #CAP_DOUBLEFEEDDETECTIONRESPONSE = $1042
  #CAP_PAPERHANDLING           = $1043
  #CAP_INDICATORSMODE          = $1044
  #CAP_PRINTERVERTICALOFFSET   = $1045
  #CAP_POWERSAVETIME           = $1046
  #CAP_PRINTERCHARROTATION     = $1047
  #CAP_PRINTERFONTSTYLE        = $1048
  #CAP_PRINTERINDEXLEADCHAR    = $1049
  #CAP_PRINTERINDEXMAXVALUE    = $104A
  #CAP_PRINTERINDEXNUMDIGITS   = $104B
  #CAP_PRINTERINDEXSTEP        = $104C
  #CAP_PRINTERINDEXTRIGGER     = $104D
  #CAP_PRINTERSTRINGPREVIEW    = $104E
  #CAP_SHEETCOUNT              = $104F
  #CAP_IMAGEADDRESSENABLED     = $1050
  #CAP_IAFIELDA_LEVEL          = $1051
  #CAP_IAFIELDB_LEVEL          = $1052
  #CAP_IAFIELDC_LEVEL          = $1053
  #CAP_IAFIELDD_LEVEL          = $1054
  #CAP_IAFIELDE_LEVEL          = $1055
  #CAP_IAFIELDA_PRINTFORMAT    = $1056
  #CAP_IAFIELDB_PRINTFORMAT    = $1057
  #CAP_IAFIELDC_PRINTFORMAT    = $1058
  #CAP_IAFIELDD_PRINTFORMAT    = $1059
  #CAP_IAFIELDE_PRINTFORMAT    = $105A
  #CAP_IAFIELDA_VALUE          = $105B
  #CAP_IAFIELDB_VALUE          = $105C
  #CAP_IAFIELDC_VALUE          = $105D
  #CAP_IAFIELDD_VALUE          = $105E
  #CAP_IAFIELDE_VALUE          = $105F
  #CAP_IAFIELDA_LASTPAGE       = $1060
  #CAP_IAFIELDB_LASTPAGE       = $1061
  #CAP_IAFIELDC_LASTPAGE       = $1062
  #CAP_IAFIELDD_LASTPAGE       = $1063
  #CAP_IAFIELDE_LASTPAGE       = $1064
  
  ; image Data sources MAY support these caps 
  #ICAP_AUTOBRIGHT                   = $1100
  #ICAP_BRIGHTNESS                   = $1101
  #ICAP_CONTRAST                     = $1103
  #ICAP_CUSTHALFTONE                 = $1104
  #ICAP_EXPOSURETIME                 = $1105
  #ICAP_FILTER                       = $1106
  #ICAP_FLASHUSED                    = $1107
  #ICAP_GAMMA                        = $1108
  #ICAP_HALFTONES                    = $1109
  #ICAP_HIGHLIGHT                    = $110a
  #ICAP_IMAGEFILEFORMAT              = $110c
  #ICAP_LAMPSTATE                    = $110d
  #ICAP_LIGHTSOURCE                  = $110e
  #ICAP_ORIENTATION                  = $1110
  #ICAP_PHYSICALWIDTH                = $1111
  #ICAP_PHYSICALHEIGHT               = $1112
  #ICAP_SHADOW                       = $1113
  #ICAP_FRAMES                       = $1114
  #ICAP_XNATIVERESOLUTION            = $1116
  #ICAP_YNATIVERESOLUTION            = $1117
  #ICAP_XRESOLUTION                  = $1118
  #ICAP_YRESOLUTION                  = $1119
  #ICAP_MAXFRAMES                    = $111a
  #ICAP_TILES                        = $111b
  #ICAP_BITORDER                     = $111c
  #ICAP_CCITTKFACTOR                 = $111d
  #ICAP_LIGHTPATH                    = $111e
  #ICAP_PIXELFLAVOR                  = $111f
  #ICAP_PLANARCHUNKY                 = $1120
  #ICAP_ROTATION                     = $1121
  #ICAP_SUPPORTEDSIZES               = $1122
  #ICAP_THRESHOLD                    = $1123
  #ICAP_XSCALING                     = $1124
  #ICAP_YSCALING                     = $1125
  #ICAP_BITORDERCODES                = $1126
  #ICAP_PIXELFLAVORCODES             = $1127
  #ICAP_JPEGPIXELTYPE                = $1128
  #ICAP_TIMEFILL                     = $112a
  #ICAP_BITDEPTH                     = $112b
  #ICAP_BITDEPTHREDUCTION            = $112c
  #ICAP_UNDEFINEDIMAGESIZE           = $112d
  #ICAP_IMAGEDATASET                 = $112e
  #ICAP_EXTIMAGEINFO                 = $112f
  #ICAP_MINIMUMHEIGHT                = $1130
  #ICAP_MINIMUMWIDTH                 = $1131
  #ICAP_AUTODISCARDBLANKPAGES        = $1134
  #ICAP_FLIPROTATION                 = $1136
  #ICAP_BARCODEDETECTIONENABLED      = $1137
  #ICAP_SUPPORTEDBARCODETYPES        = $1138
  #ICAP_BARCODEMAXSEARCHPRIORITIES   = $1139
  #ICAP_BARCODESEARCHPRIORITIES      = $113a
  #ICAP_BARCODESEARCHMODE            = $113b
  #ICAP_BARCODEMAXRETRIES            = $113c
  #ICAP_BARCODETIMEOUT               = $113d
  #ICAP_ZOOMFACTOR                   = $113e
  #ICAP_PATCHCODEDETECTIONENABLED    = $113f
  #ICAP_SUPPORTEDPATCHCODETYPES      = $1140
  #ICAP_PATCHCODEMAXSEARCHPRIORITIES = $1141
  #ICAP_PATCHCODESEARCHPRIORITIES    = $1142
  #ICAP_PATCHCODESEARCHMODE          = $1143
  #ICAP_PATCHCODEMAXRETRIES          = $1144
  #ICAP_PATCHCODETIMEOUT             = $1145
  #ICAP_FLASHUSED2                   = $1146
  #ICAP_IMAGEFILTER                  = $1147
  #ICAP_NOISEFILTER                  = $1148
  #ICAP_OVERSCAN                     = $1149
  #ICAP_AUTOMATICBORDERDETECTION     = $1150
  #ICAP_AUTOMATICDESKEW              = $1151
  #ICAP_AUTOMATICROTATE              = $1152
  #ICAP_JPEGQUALITY                  = $1153
  #ICAP_FEEDERTYPE                   = $1154
  #ICAP_ICCPROFILE                   = $1155
  #ICAP_AUTOSIZE                     = $1156
  #ICAP_AUTOMATICCROPUSESFRAME       = $1157
  #ICAP_AUTOMATICLENGTHDETECTION     = $1158
  #ICAP_AUTOMATICCOLORENABLED        = $1159
  #ICAP_AUTOMATICCOLORNONCOLORPIXELTYPE = $115a
  #ICAP_COLORMANAGEMENTENABLED       = $115b
  #ICAP_IMAGEMERGE                   = $115c
  #ICAP_IMAGEMERGEHEIGHTTHRESHOLD    = $115d
  #ICAP_SUPPORTEDEXTIMAGEINFO        = $115e
  #ICAP_FILMTYPE                     = $115f
  #ICAP_MIRROR                       = $1160
  #ICAP_JPEGSUBSAMPLING              = $1161
  
  ; image Data sources MAY support these audio caps 
  #ACAP_XFERMECH                     = $1202
  
  
  ;**************************************************************************
  ;*            Extended Image Info Attributes section  Added 1.7           *
  ;**************************************************************************
  
  #TWEI_BARCODEX               = $1200
  #TWEI_BARCODEY               = $1201
  #TWEI_BARCODETEXT            = $1202
  #TWEI_BARCODETYPE            = $1203
  #TWEI_DESHADETOP             = $1204
  #TWEI_DESHADELEFT            = $1205
  #TWEI_DESHADEHEIGHT          = $1206
  #TWEI_DESHADEWIDTH           = $1207
  #TWEI_DESHADESIZE            = $1208
  #TWEI_SPECKLESREMOVED        = $1209
  #TWEI_HORZLINEXCOORD         = $120A
  #TWEI_HORZLINEYCOORD         = $120B
  #TWEI_HORZLINELENGTH         = $120C
  #TWEI_HORZLINETHICKNESS      = $120D
  #TWEI_VERTLINEXCOORD         = $120E
  #TWEI_VERTLINEYCOORD         = $120F
  #TWEI_VERTLINELENGTH         = $1210
  #TWEI_VERTLINETHICKNESS      = $1211
  #TWEI_PATCHCODE              = $1212
  #TWEI_ENDORSEDTEXT           = $1213
  #TWEI_FORMCONFIDENCE         = $1214
  #TWEI_FORMTEMPLATEMATCH      = $1215
  #TWEI_FORMTEMPLATEPAGEMATCH  = $1216
  #TWEI_FORMHORZDOCOFFSET      = $1217
  #TWEI_FORMVERTDOCOFFSET      = $1218
  #TWEI_BARCODECOUNT           = $1219
  #TWEI_BARCODECONFIDENCE      = $121A
  #TWEI_BARCODEROTATION        = $121B
  #TWEI_BARCODETEXTLENGTH      = $121C
  #TWEI_DESHADECOUNT           = $121D
  #TWEI_DESHADEBLACKCOUNTOLD   = $121E
  #TWEI_DESHADEBLACKCOUNTNEW   = $121F
  #TWEI_DESHADEBLACKRLMIN      = $1220
  #TWEI_DESHADEBLACKRLMAX      = $1221
  #TWEI_DESHADEWHITECOUNTOLD   = $1222
  #TWEI_DESHADEWHITECOUNTNEW   = $1223
  #TWEI_DESHADEWHITERLMIN      = $1224
  #TWEI_DESHADEWHITERLAVE      = $1225
  #TWEI_DESHADEWHITERLMAX      = $1226
  #TWEI_BLACKSPECKLESREMOVED   = $1227
  #TWEI_WHITESPECKLESREMOVED   = $1228
  #TWEI_HORZLINECOUNT          = $1229
  #TWEI_VERTLINECOUNT          = $122A
  #TWEI_DESKEWSTATUS           = $122B
  #TWEI_SKEWORIGINALANGLE      = $122C
  #TWEI_SKEWFINALANGLE         = $122D
  #TWEI_SKEWCONFIDENCE         = $122E
  #TWEI_SKEWWINDOWX1           = $122F
  #TWEI_SKEWWINDOWY1           = $1230
  #TWEI_SKEWWINDOWX2           = $1231
  #TWEI_SKEWWINDOWY2           = $1232
  #TWEI_SKEWWINDOWX3           = $1233
  #TWEI_SKEWWINDOWY3           = $1234
  #TWEI_SKEWWINDOWX4           = $1235
  #TWEI_SKEWWINDOWY4           = $1236
  #TWEI_BOOKNAME               = $1238
  #TWEI_CHAPTERNUMBER          = $1239
  #TWEI_DOCUMENTNUMBER         = $123A
  #TWEI_PAGENUMBER             = $123B
  #TWEI_CAMERA                 = $123C
  #TWEI_FRAMENUMBER            = $123D
  #TWEI_FRAME                  = $123E
  #TWEI_PIXELFLAVOR            = $123F
  #TWEI_ICCPROFILE             = $1240
  #TWEI_LASTSEGMENT            = $1241
  #TWEI_SEGMENTNUMBER          = $1242
  #TWEI_MAGDATA                = $1243
  #TWEI_MAGTYPE                = $1244
  #TWEI_PAGESIDE               = $1245
  #TWEI_FILESYSTEMSOURCE       = $1246
  #TWEI_IMAGEMERGED            = $1247
  #TWEI_MAGDATALENGTH          = $1248
  #TWEI_PAPERCOUNT             = $1249
  #TWEI_PRINTERTEXT            = $124A
  #TWEI_TWAINDIRECTMETADATA    = $124B
  #TWEI_IAFIELDA_VALUE         = $124C
  #TWEI_IAFIELDB_VALUE         = $124D
  #TWEI_IAFIELDC_VALUE         = $124E
  #TWEI_IAFIELDD_VALUE         = $124F
  #TWEI_IAFIELDE_VALUE         = $1250
  #TWEI_IALEVEL                = $1251
  #TWEI_PRINTER                = $1252
  #TWEI_BARCODETEXT2           = $1253
  
  #TWEJ_NONE                   = $0000
  #TWEJ_MIDSEPARATOR           = $0001
  #TWEJ_PATCH1                 = $0002
  #TWEJ_PATCH2                 = $0003
  #TWEJ_PATCH3                 = $0004
  #TWEJ_PATCH4                 = $0005
  #TWEJ_PATCH6                 = $0006
  #TWEJ_PATCHT                 = $0007
  
  
  ;**************************************************************************
  ;*            Return Codes And Condition Codes section                    *
  ;**************************************************************************
  
  #TWRC_CUSTOMBASE     = $8000
  
  #TWRC_SUCCESS        = 0
  #TWRC_FAILURE        = 1
  #TWRC_CHECKSTATUS    = 2
  #TWRC_CANCEL         = 3
  #TWRC_DSEVENT        = 4
  #TWRC_NOTDSEVENT     = 5
  #TWRC_XFERDONE       = 6
  #TWRC_ENDOFLIST      = 7
  #TWRC_INFONOTSUPPORTED = 8
  #TWRC_DATANOTAVAILABLE = 9
  #TWRC_BUSY           = 10
  #TWRC_SCANNERLOCKED  = 11
  
  ; Condition Codes: Application gets these by doing DG_CONTROL DAT_STATUS MSG_GET.
  #TWCC_CUSTOMBASE         = $8000
  
  #TWCC_SUCCESS          = 0
  #TWCC_BUMMER           = 1
  #TWCC_LOWMEMORY        = 2
  #TWCC_NODS             = 3
  #TWCC_MAXCONNECTIONS   = 4
  #TWCC_OPERATIONERROR   = 5
  #TWCC_BADCAP           = 6
  #TWCC_BADPROTOCOL      = 9
  #TWCC_BADVALUE         = 10
  #TWCC_SEQERROR         = 11
  #TWCC_BADDEST          = 12
  #TWCC_CAPUNSUPPORTED   = 13
  #TWCC_CAPBADOPERATION  = 14
  #TWCC_CAPSEQERROR      = 15
  #TWCC_DENIED           = 16
  #TWCC_FILEEXISTS       = 17
  #TWCC_FILENOTFOUND     = 18
  #TWCC_NOTEMPTY         = 19
  #TWCC_PAPERJAM         = 20
  #TWCC_PAPERDOUBLEFEED  = 21
  #TWCC_FILEWRITEERROR   = 22
  #TWCC_CHECKDEVICEONLINE= 23
  #TWCC_INTERLOCK        = 24
  #TWCC_DAMAGEDCORNER    = 25
  #TWCC_FOCUSERROR       = 26
  #TWCC_DOCTOOLIGHT      = 27
  #TWCC_DOCTOODARK       = 28
  #TWCC_NOMEDIA          = 29
  
  ; bit patterns: For query the operation that are supported by the Data source on a capability 
  ; Application gets these through DG_CONTROL/DAT_CAPABILITY/MSG_QUERYSUPPORT 
  #TWQC_GET              = $0001
  #TWQC_SET              = $0002
  #TWQC_GETDEFAULT       = $0004
  #TWQC_GETCURRENT       = $0008
  #TWQC_RESET            = $0010
  #TWQC_SETCONSTRAINT    = $0020
  #TWQC_GETHELP          = $0100
  #TWQC_GETLABEL         = $0200
  #TWQC_GETLABELENUM     = $0400
  
  ;***************************************************************************
  ;* Depreciated Items                                                       *
  ;***************************************************************************
  ; #if Defined(WIN32) || Defined(WIN64)
  ;         #TW_HUGE
  ; #elif !Defined(TWH_CMP_GNU)
  ;         #TW_HUGE    huge
  ; #else
  ;         #TW_HUGE
  ; #endif
  ; 
  ; typedef BYTE TW_HUGE * HPBYTE;
  ; typedef void TW_HUGE * HPVOID;
  ; 
  ; typedef unsigned char     TW_STR1024[1026],   FAR *pTW_STR1026, FAR *pTW_STR1024;
  ; typedef wchar_t           TW_UNI512[512],     FAR *pTW_UNI512;
  
  #TWTY_STR1024          = $000d
  #TWTY_UNI512           = $000e
  
  #TWFF_JPN            = 12
  
  #DAT_TWUNKIDENTITY     = $000b
  #DAT_SETUPFILEXFER2    = $0301
  
  #CAP_CLEARBUFFERS          = $101d
  #CAP_SUPPORTEDCAPSEXT      = $100c
  ;#CAP_FILESYSTEM            ;= $????
  #CAP_PAGEMULTIPLEACQUIRE   = $1023
  #CAP_PAPERBINDING          = $102f
  #CAP_PASSTHRU              = $1031
  #CAP_POWERDOWNTIME         = $1034
  #ACAP_AUDIOFILEFORMAT      = $1201
  
  #MSG_CHECKSTATUS       = $0201
  
  #MSG_INVOKE_CALLBACK   = $0903    ; Mac Only, deprecated - use DAT_NULL And MSG_xxx instead 
  
  #TWQC_CONSTRAINABLE    = $0040
  
  #TWSX_FILE2          = 3
  
  ; CAP_FILESYSTEM values (FS_ means file system) 
  #TWFS_FILESYSTEM     = 0
  #TWFS_RECURSIVEDELETE= 1
  
  ; ICAP_PIXELTYPE values (PT_ means Pixel Type) 
  #TWPT_SRGB64   = 11
  #TWPT_BGR      = 12
  #TWPT_CIELAB   = 13
  #TWPT_CIELUV   = 14
  #TWPT_YCBCR    = 15
  
  ; ICAP_SUPPORTEDSIZES values (SS_ means Supported Sizes) 
  #TWSS_B              = 8
  #TWSS_A4LETTER     = #TWSS_A4
  #TWSS_B3          = #TWSS_ISOB3
  #TWSS_B4          = #TWSS_ISOB4
  #TWSS_B6          = #TWSS_ISOB6
  #TWSS_B5LETTER    = #TWSS_JISB5
  
  ; ACAP_AUDIOFILEFORMAT values (AF_ means audio format).  Added 1.8 
  #TWAF_WAV    = 0
  #TWAF_AIFF   = 1
  #TWAF_AU     = 3
  #TWAF_SND    = 4
  
  ; CAP_CLEARBUFFERS values 
  #TWCB_AUTO              = 0
  #TWCB_CLEAR             = 1
  #TWCB_NOCLEAR           = 2
  
  
  
  
  ; Start of DTWAIN constant definitions 
  #DTWAIN_TRUE          = 1
  #DTWAIN_FALSE         = 0
  
  #DTWAIN_FF_TIFF       = 0
  #DTWAIN_FF_PICT       = 1
  #DTWAIN_FF_BMP        = 2
  #DTWAIN_FF_XBM        = 3
  #DTWAIN_FF_JFIF       = 4
  #DTWAIN_FF_FPX        = 5
  #DTWAIN_FF_TIFFMULTI  = 6
  #DTWAIN_FF_PNG        = 7
  #DTWAIN_FF_SPIFF      = 8
  #DTWAIN_FF_EXIF       = 9
  #DTWAIN_FF_PDF        = 10
  #DTWAIN_FF_JP2        = 11
  #DTWAIN_FF_JPX        = 13
  #DTWAIN_FF_DEJAVU     = 14
  #DTWAIN_FF_PDFA       = 15
  #DTWAIN_FF_PDFA2      = 16
  #DTWAIN_FF_PDFRASTER  = 17
  
  ; Compression Types For buffered And file transfers 
  #DTWAIN_CP_NONE       = 0
  #DTWAIN_CP_PACKBITS   = 1
  #DTWAIN_CP_GROUP31D   = 2
  #DTWAIN_CP_GROUP31DEOL= 3
  #DTWAIN_CP_GROUP32D   = 4
  #DTWAIN_CP_GROUP4     = 5
  #DTWAIN_CP_JPEG       = 6
  #DTWAIN_CP_LZW        = 7
  #DTWAIN_CP_JBIG       = 8
  #DTWAIN_CP_PNG        = 9
  #DTWAIN_CP_RLE4       = 10
  #DTWAIN_CP_RLE8       = 11
  #DTWAIN_CP_BITFIELDS  = 12
  #DTWAIN_CP_ZIP        = 13
  #DTWAIN_CP_JPEG2000   = 14
  
  
  ; Frame Sizes.  Same as TWAIN= 1.8.  Use these values for
  ; setting the frame size, or to specify a PDF page size
  ; if acquiring To PDF files 
  #DTWAIN_FS_NONE       = 0
  #DTWAIN_FS_A4LETTER   = 1
  #DTWAIN_FS_B5LETTER   = 2
  #DTWAIN_FS_USLETTER   = 3
  #DTWAIN_FS_USLEGAL    = 4
  #DTWAIN_FS_A5         = 5
  #DTWAIN_FS_B4         = 6
  #DTWAIN_FS_B6         = 7
  #DTWAIN_FS_USLEDGER   = 9
  #DTWAIN_FS_USEXECUTIVE= 10
  #DTWAIN_FS_A3         = 11
  #DTWAIN_FS_B3         = 12
  #DTWAIN_FS_A6         = 13
  #DTWAIN_FS_C4         = 14
  #DTWAIN_FS_C5         = 15
  #DTWAIN_FS_C6         = 16
  #DTWAIN_FS_4A0         = 17
  #DTWAIN_FS_2A0         = 18
  #DTWAIN_FS_A0          = 19
  #DTWAIN_FS_A1          = 20
  #DTWAIN_FS_A2          = 21
  #DTWAIN_FS_A4          = #DTWAIN_FS_A4LETTER
  #DTWAIN_FS_A7          = 22
  #DTWAIN_FS_A8          = 23
  #DTWAIN_FS_A9          = 24
  #DTWAIN_FS_A10         = 25
  #DTWAIN_FS_ISOB0       = 26
  #DTWAIN_FS_ISOB1       = 27
  #DTWAIN_FS_ISOB2       = 28
  #DTWAIN_FS_ISOB3       = #DTWAIN_FS_B3
  #DTWAIN_FS_ISOB4       = #DTWAIN_FS_B4
  #DTWAIN_FS_ISOB5       = 29
  #DTWAIN_FS_ISOB6       = #DTWAIN_FS_B6
  #DTWAIN_FS_ISOB7       = 30
  #DTWAIN_FS_ISOB8       = 31
  #DTWAIN_FS_ISOB9       = 32
  #DTWAIN_FS_ISOB10      = 33
  #DTWAIN_FS_JISB0       = 34
  #DTWAIN_FS_JISB1       = 35
  #DTWAIN_FS_JISB2       = 36
  #DTWAIN_FS_JISB3       = 37
  #DTWAIN_FS_JISB4       = 38
  #DTWAIN_FS_JISB5       = #DTWAIN_FS_B5LETTER
  #DTWAIN_FS_JISB6       = 39
  #DTWAIN_FS_JISB7       = 40
  #DTWAIN_FS_JISB8       = 41
  #DTWAIN_FS_JISB9       = 42
  #DTWAIN_FS_JISB10      = 43
  #DTWAIN_FS_C0          = 44
  #DTWAIN_FS_C1          = 45
  #DTWAIN_FS_C2          = 46
  #DTWAIN_FS_C3          = 47
  #DTWAIN_FS_C7          = 48
  #DTWAIN_FS_C8          = 49
  #DTWAIN_FS_C9          = 50
  #DTWAIN_FS_C10         = 51
  #DTWAIN_FS_USSTATEMENT = 52
  #DTWAIN_FS_BUSINESSCARD= 53
  
  
  ; Parameter used when any support is desired 
  #DTWAIN_ANYSUPPORT  = (-1)
  
  ;#include "dtwain_filetypes.h"
  
  ; Units of measure 
  #DTWAIN_INCHES     = 0
  #DTWAIN_CENTIMETERS= 1
  #DTWAIN_PICAS      = 2
  #DTWAIN_POINTS     = 3
  #DTWAIN_TWIPS      = 4
  #DTWAIN_PIXELS     = 5
  #DTWAIN_MILLIMETERS= 6
  
  ; File Acquire flags 
  #DTWAIN_USENATIVE         = 1
  #DTWAIN_USEBUFFERED       = 2
  #DTWAIN_USECOMPRESSION    = 4
  #DTWAIN_USEMEMFILE        = 8
  #DTWAIN_USENAME           = 16
  #DTWAIN_USEPROMPT         = 32
  #DTWAIN_USELONGNAME       = 64
  #DTWAIN_USESOURCEMODE     = 128
  #DTWAIN_USELIST           = 256
  #DTWAIN_CREATE_DIRECTORY  = 512
  
  
  ;= #DTWAIN_ARRAY types 
  #DTWAIN_ARRAYANY            = 1
  #DTWAIN_ARRAYLONG           = 2
  #DTWAIN_ARRAYFLOAT          = 3
  #DTWAIN_ARRAYHANDLE         = 4
  #DTWAIN_ARRAYSOURCE         = 5
  #DTWAIN_ARRAYSTRING         = 6
  #DTWAIN_ARRAYFRAME          = 7
  #DTWAIN_ARRAYBOOL           = #DTWAIN_ARRAYLONG
  #DTWAIN_ARRAYLONGSTRING     = 8
  #DTWAIN_ARRAYUNICODESTRING  = 9
  #DTWAIN_ARRAYLONG64         = 10
  #DTWAIN_ArrayTypePTR        = #DTWAIN_ARRAYHANDLE
  #DTWAIN_ARRAYOFHANDLEARRAYS = 2000
  ; Same string type As= #DTWAIN_ARRAYSTRING
  ; if compiling non-UNICODE= (MBCS) applications 
  #DTWAIN_ARRAYANSISTRING     = 11
  
  ; Same string type As= #DTWAIN_ARRAYSTRING
  ; if compiling UNICODE applications 
  #DTWAIN_ARRAYWIDESTRING     = 12
  #DTWAIN_ARRAYTWFIX32        = 200
  
  #DTWAIN_ArrayTypeINVALID    = 0
  
  ;= #DTWAIN_ARRAY interpreted constants= (used To distinguish integer types)
  ; All integer types are stored As LONG Or LONG64.  The interpreter is used To
  ; let the app know what type of LONGs are stored= (signed, unsigned,= 16 bit signed
  ;= 16-bit unsigned, BOOLs
  
  #DTWAIN_ARRAYINT16        = 100
  #DTWAIN_ARRAYUINT16       = 110
  #DTWAIN_ARRAYUINT32       = 120
  #DTWAIN_ARRAYINT32        = 130
  #DTWAIN_ARRAYINT64        = 140
  
  ;= #DTWAIN_RANGE types 
  #DTWAIN_RANGELONG     = #DTWAIN_ARRAYLONG
  #DTWAIN_RANGEFLOAT    = #DTWAIN_ARRAYFLOAT
  
  ;= #DTWAIN_RANGE constants 
  #DTWAIN_RANGEMIN    = 0
  #DTWAIN_RANGEMAX    = 1
  #DTWAIN_RANGESTEP   = 2
  #DTWAIN_RANGEDEFAULT  = 3
  #DTWAIN_RANGECURRENT  = 4
  
  ;= #DTWAIN_FRAME constants 
  #DTWAIN_FRAMELEFT     = 0
  #DTWAIN_FRAMETOP      = 1
  #DTWAIN_FRAMERIGHT    = 2
  #DTWAIN_FRAMEBOTTOM   = 3
  
  ;= #DTWAIN_FIX32 constants 
  #DTWAIN_FIX32WHOLE    = 0
  #DTWAIN_FIX32FRAC     = 1
  
  ;= #DTWAIN Job Control constants 
  #DTWAIN_JC_NONE       = 0
  #DTWAIN_JC_JSIC       = 1
  #DTWAIN_JC_JSIS       = 2
  #DTWAIN_JC_JSXC       = 3
  #DTWAIN_JC_JSXS       = 4
  
  ; Constant used For unknown capability type 
  #DTWAIN_CAPDATATYPE_UNKNOWN = (-10)
  
  ; These job control constants are For devices that do
  ; not have TWAIN job control support 
  #DTWAIN_JCBP_JSIC       = 5
  #DTWAIN_JCBP_JSIS       = 6
  #DTWAIN_JCBP_JSXC       = 7
  #DTWAIN_JCBP_JSXS       = 8
  
  
  ;= #DTWAIN Feeder control constants 
  #DTWAIN_FEEDPAGEON   = 1
  #DTWAIN_CLEARPAGEON  = 2
  #DTWAIN_REWINDPAGEON = 4
  
  ; Source settings 
  #DTWAIN_AppOwnsDib             = 1
  #DTWAIN_SourceOwnsDib          = 2
  
  ; Container Types 
  ; Start at= 2^3=8 since the TWAIN constants start at= 3 And are contiguous 
  #DTWAIN_CONTARRAY          = 8
  #DTWAIN_CONTENUMERATION    = 16
  #DTWAIN_CONTONEVALUE       = 32
  #DTWAIN_CONTRANGE          = 64
  #DTWAIN_CONTDEFAULT        = 0
  
  ; Get capability types 
  #DTWAIN_CAPGET               = 1
  #DTWAIN_CAPGETCURRENT        = 2
  #DTWAIN_CAPGETDEFAULT        = 3
  
  #DTWAIN_CAPSET               = 6 ; Set one Or more values                   
  #DTWAIN_CAPRESET             = 7 ; Set current value To Default value       
  #DTWAIN_CAPRESETALL          = 8 ; Reset all capabilities 
  #DTWAIN_CAPSETCONSTRAINT     = 9 ; constrain values 
  
  #DTWAIN_CAPGETHELP           = 9
  #DTWAIN_CAPGETLABEL          = 10
  #DTWAIN_CAPGETLABELENUM      = 11
  
  ; The following values are ORed With the= #DTWAIN_CAPSET value 
  #DTWAIN_CAPSETAVAILABLE      = 8  ; Sets available values  
  #DTWAIN_CAPSETCURRENT        = 16 ; Sets current values    
  
  #DTWAIN_AREASET              = #DTWAIN_CAPSET
  #DTWAIN_AREARESET            = #DTWAIN_CAPRESET
  #DTWAIN_AREACURRENT          = #DTWAIN_CAPGETCURRENT
  #DTWAIN_AREADEFAULT          = #DTWAIN_CAPGETDEFAULT
  
  ; Twain version types 
  #DTWAIN_VER15               = 0
  #DTWAIN_VER16               = 1
  #DTWAIN_VER17               = 2
  #DTWAIN_VER18               = 3
  #DTWAIN_VER20               = 4
  #DTWAIN_VER21               = 5
  #DTWAIN_VER22               = 6
  
  ;= #DTWAIN transfer 
  #DTWAIN_ACQUIREALL           = (-1)
  #DTWAIN_MAXACQUIRE           = (-1)
  
  ;= #DTWAIN Duplex constants 
  #DTWAIN_DX_NONE        = 0
  #DTWAIN_DX_1PASSDUPLEX = 1
  #DTWAIN_DX_2PASSDUPLEX = 2
  
  ; Twain Pixel Types 
  #DTWAIN_PT_BW       = 0 
  #DTWAIN_PT_GRAY     = 1
  #DTWAIN_PT_RGB      = 2
  #DTWAIN_PT_PALETTE  = 3
  #DTWAIN_PT_CMY      = 4
  #DTWAIN_PT_CMYK     = 5
  #DTWAIN_PT_YUV      = 6
  #DTWAIN_PT_YUVK     = 7
  #DTWAIN_PT_CIEXYZ   = 8
  #DTWAIN_PT_LAB      = 9
  #DTWAIN_PT_SRGB     = 10
  #DTWAIN_PT_SCRGB    = 11
  #DTWAIN_PT_INFRARED = 16
  #DTWAIN_PT_DEFAULT  = 1000
  
  #DTWAIN_CURRENT     = (-2)
  #DTWAIN_DEFAULT     = (-1)
  #DTWAIN_FLOATDEFAULT= (-9999.0)
  
  #DTWAIN_DGNAME  = 0
  #DTWAIN_DATNAME = 1
  #DTWAIN_MSGNAME = 2
  
  ;= #DTWAIN Callback constants 
  #DTWAIN_CallbackERROR   = 1
  #DTWAIN_CallbackMESSAGE = 2
  
  ;= #DTWAIN Special Failure codes 
  #DTWAIN_FAILURE1      = (-1)
  #DTWAIN_FAILURE2      = (-2)
  
  ; Other miscellaneous constants 
  #DTWAIN_DELETEALL     = (-1)
  
  ; Page total page(s) transferred wParam's 
  ; Sent when an acquisition has been successful 
  #DTWAIN_TN_ACQUIREDONE         = 1000
  
  ; Sent when an acquisition has been failed 
  #DTWAIN_TN_ACQUIREFAILED       = 1001
  ; Cancelled the acquisition 
  #DTWAIN_TN_ACQUIRECANCELLED    = 1002
  #DTWAIN_TN_ACQUIRECANCELED     = 1002
  ; Started an acquisition 
  #DTWAIN_TN_ACQUIRESTARTED      = 1003
  
  ; Sent when= #DTWAIN transfers individual pages For a multi-page scan 
  ; Do we get the Next page? 
  #DTWAIN_TN_PAGECONTINUE        = 1004
  ; Page failed To be acquired 
  #DTWAIN_TN_PAGEFAILED          = 1005
  ; Page cancelled 
  #DTWAIN_TN_PAGECANCELLED       = 1006
  #DTWAIN_TN_PAGECANCELED        = 1006
  
  ; Sent when TWAIN is in the "Transfer ready" state= (State= 6) 
  #DTWAIN_TN_TRANSFERREADY       = 1009
  ; Sent when TWAIN is in the "Transfer done" state= (State= 7) 
  #DTWAIN_TN_TRANSFERDONE        = 1010
  #DTWAIN_TN_ACQUIREPAGEDONE     = 1010
  
  ; Source closing/opening wParam's 
  #DTWAIN_TN_UICLOSING                     = 1011
  #DTWAIN_TN_UICLOSED                      = 1012
  #DTWAIN_TN_UIOPENED                      = 1013
  #DTWAIN_TN_UIOPENING                     = 1055
  #DTWAIN_TN_UIOPENFAILURE                 = 1060
  
  ; Twain page transferrance wParam's 
  #DTWAIN_TN_CLIPTRANSFERDONE              = 1014
  
  ; Invalid image file format specified Or image could Not be saved To file 
  #DTWAIN_TN_INVALIDIMAGEFORMAT            = 1015
  
  ; Sent when the UI is closed, And all processing of DIBs has been done 
  #DTWAIN_TN_ACQUIRETERMINATED             = 1021
  
  ; Sent when a strip has been successfully transferred from a buffered transfer 
  #DTWAIN_TN_TRANSFERSTRIPREADY             = 1022
  #DTWAIN_TN_TRANSFERSTRIPDONE              = 1023
  
  ; Sent If a buffered strip transfer fails due To lack of memory 
  #DTWAIN_TN_TRANSFERSTRIPFAILED            = 1029
  
  ; Sent If the image info is invalid 
  #DTWAIN_TN_IMAGEINFOERROR                 = 1024
  
  ; Sent If program decides To cancel the initial transfer 
  #DTWAIN_TN_TRANSFERCANCELLED         = 1030
  #DTWAIN_TN_TRANSFERCANCELED          = 1030
  
  ; Sent If user cancels the saving of a file using the file prompt 
  #DTWAIN_TN_FILESAVECANCELLED        = 1031
  #DTWAIN_TN_FILESAVECANCELED        = 1031
  #DTWAIN_TN_FILESAVEOK               = 1032
  #DTWAIN_TN_FILESAVEERROR            = 1033
  #DTWAIN_TN_FILEPAGESAVEOK           = 1034
  #DTWAIN_TN_FILEPAGESAVEERROR        = 1035
  #DTWAIN_TN_PROCESSEDDIB             = 1036
  
  
  ; Sent If document feeder has paper loaded 
  #DTWAIN_TN_FEEDERLOADED             = 1037
  
  ; Sent whenever a= #DTWAIN error is generated
  ; This is only available For= #DTWAIN_SetCallback functions 
  #DTWAIN_TN_GENERALERROR            = 1038
  
  ; Sent when in manual duplex mode 
  ; Side= 1 completed successfully 
  #DTWAIN_TN_MANDUPFLIPPAGES         = 1040
  
  ; Side= 1 completed, maybe successful depending on Return value 
  #DTWAIN_TN_MANDUPSIDE1DONE         = 1041
  
  ; Side= 2 completed, maybe successful depending on Return value 
  #DTWAIN_TN_MANDUPSIDE2DONE         = 1042
  
  ; Both sides done, but page count mismatch occurred 
  #DTWAIN_TN_MANDUPPAGECOUNTERROR    = 1043
  
  ; Both sides done, everything is successful 
  #DTWAIN_TN_MANDUPACQUIREDONE       = 1044
  
  ; Side= 1 started 
  #DTWAIN_TN_MANDUPSIDE1START        = 1045
  
  ; Side= 2 started 
  #DTWAIN_TN_MANDUPSIDE2START        = 1046
  
  ; Error when merging the acquired pages 
  #DTWAIN_TN_MANDUPMERGEERROR        = 1047
  
  ; Error when attempting To allocate memory For duplexed page 
  #DTWAIN_TN_MANDUPMEMORYERROR       = 1048
  
  ; Error when attempting To Read image Data For duplexed page 
  #DTWAIN_TN_MANDUPFILEERROR         = 1049
  
  ; Error when attempting To save duplex file 
  #DTWAIN_TN_MANDUPFILESAVEERROR     = 1050
  
  ; End of Job control message 
  #DTWAIN_TN_ENDOFJOBDETECTED        = 1051
  #DTWAIN_TN_EOJDETECTED             = 1051
  
  ; End of job when message when transfer is initially done 
  #DTWAIN_TN_EOJDETECTED_XFERDONE   = 1052
  
  ; Query If page should be saved Or discarded 
  #DTWAIN_TN_QUERYPAGEDISCARD         = 1053
  
  ; Send If page was discarded from save 
  #DTWAIN_TN_PAGEDISCARDED            = 1054
  
  ; Sent To application To acknowledge that
  ; the page will no longer go through further processing when acquired
  ; from device 
  #DTWAIN_TN_PROCESSDIBACCEPTED  = 1055
  #DTWAIN_TN_PROCESSDIBFINALACCEPTED  = 1056
  
  ; Miscellaneous file transfer notifications 
  #DTWAIN_TN_CLOSEDIBFAILED      = 1057
  
  
  ; Device event For TWAIN= 1.8 Sources 
  #DTWAIN_TN_DEVICEEVENT                   = 1100
  
  ; Sent If TWAIN driver sends cancel code during acquisition 
  #DTWAIN_TN_TWAINPAGECANCELLED      = 1105
  #DTWAIN_TN_TWAINPAGECANCELED       = 1105
  
  ; Sent If TWAIN driver sends failure code during acquisition 
  #DTWAIN_TN_TWAINPAGEFAILED         = 1106
  
  ; Sent If application changes DIB 
  #DTWAIN_TN_APPUPDATEDDIB           = 1107
  
  ; Sent when saving a page using the
  ;= #DTWAIN_FILESAVE_UICLOSE,= #DTWAIN_FILESAVE_SOURCECLOSE option is used 
  #DTWAIN_TN_FILEPAGESAVING          = 1110
  
  ; Sent when job is being saved To file 
  #DTWAIN_TN_EOJBEGINFILESAVE        = 1112
  
  ; Sent after job saved To file= (sent regardless If there is an error) 
  #DTWAIN_TN_EOJENDFILESAVE          = 1113
  
  ; Sent when copping DIB fails 
  #DTWAIN_TN_CROPFAILED              = 1120
  
  ; Sent on naive Or buffered transfer done
  ; and DIB has been fully processed by= #DTWAIN 
  #DTWAIN_TN_PROCESSEDDIBFINAL       = 1121
  
  ; Determine If blank page has been detected 
  #DTWAIN_TN_BLANKPAGEDETECTED1      = 1130
  #DTWAIN_TN_BLANKPAGEDETECTED2      = 1131
  #DTWAIN_TN_BLANKPAGEDETECTED3      = 1132
  #DTWAIN_TN_BLANKPAGEDISCARDED1     = 1133
  #DTWAIN_TN_BLANKPAGEDISCARDED2     = 1134
  
  ; Messages sent when text acquired from OCR 
  #DTWAIN_TN_OCRTEXTRETRIEVED        = 1140
  #DTWAIN_TN_QUERYOCRTEXT            = 1141
  #DTWAIN_TN_PDFOCRREADY             = 1142
  #DTWAIN_TN_PDFOCRDONE              = 1143
  #DTWAIN_TN_PDFOCRERROR             = 1144
  
  ; Message sent when= #DTWAIN_SetCallback() is invoked on a non-NULL callback function 
  #DTWAIN_TN_SETCALLBACKINIT         = 1150
  #DTWAIN_TN_SETCALLBACK64INIT       = 1151
  
  ; Sent when a file name is generated when saving images To files 
  #DTWAIN_TN_FILENAMECHANGING        = 1160
  #DTWAIN_TN_FILENAMECHANGED         = 1161
  
  ; Sent when an audio file has been transferred 
  #DTWAIN_TN_PROCESSEDAUDIOFINAL      = 1180
  #DTWAIN_TN_PROCESSAUDIOFINALACCEPTED= 1181
  #DTWAIN_TN_PROCESSEDAUDIOFILE       = 1182
  
  ; Sent when a TWAIN triplet is being processed 
  #DTWAIN_TN_TWAINTRIPLETBEGIN        = 1183
  #DTWAIN_TN_TWAINTRIPLETEND          = 1184
  
  ; Sent If document feeder has no paper loaded 
  #DTWAIN_TN_FEEDERNOTLOADED          = 1200
  
  ; PDF OCR clean text flags 
  #DTWAIN_PDFOCR_CLEANTEXT1           = 1
  #DTWAIN_PDFOCR_CLEANTEXT2           = 2
  
  ;= #DTWAIN Acquire Modes 
  #DTWAIN_MODAL                       = 0
  #DTWAIN_MODELESS                    = 1
  
  ;= #DTWAIN Source UI Mode 
  #DTWAIN_UIModeCLOSE                   = 0
  #DTWAIN_UIModeOPEN                    = 1
  
  #DTWAIN_REOPEN_SOURCE                 = 2
  
  ;= #DTWAIN Rounding For range values 
  #DTWAIN_ROUNDNEAREST  = 0
  #DTWAIN_ROUNDUP       = 1
  #DTWAIN_ROUNDDOWN     = 2
  #DTWAIN_FLOATDELTA    = (0.00000001)
  
  ; Rotations= (same As TWAIN definitions) 
  #DTWAIN_OR_ROT0          = 0
  #DTWAIN_OR_ROT90         = 1
  #DTWAIN_OR_ROT180        = 2
  #DTWAIN_OR_ROT270        = 3
  #DTWAIN_OR_PORTRAIT      = #DTWAIN_OR_ROT0
  #DTWAIN_OR_LANDSCAPE     = #DTWAIN_OR_ROT270
  #DTWAIN_OR_ANYROTATION   = (-1)
  
  ; Cap operation support constants= (same As TWAIN= 2.x ) 
  #DTWAIN_CO_GET          = $0001
  #DTWAIN_CO_SET          = $0002
  #DTWAIN_CO_GETDEFAULT   = $0004
  #DTWAIN_CO_GETCURRENT   = $0008
  #DTWAIN_CO_RESET        = $0010
  #DTWAIN_CO_SETCONSTRAINT= $0020
  #DTWAIN_CO_CONSTRAINABLE   = $0040
  #DTWAIN_CO_GETHELP         = $0100
  #DTWAIN_CO_GETLABEL        = $0200
  #DTWAIN_CO_GETLABELENUM    = $0400
  
  
  ; Country information 
  #DTWAIN_CNTYAFGHANISTAN            = 1001
  #DTWAIN_CNTYALGERIA                 = 213
  #DTWAIN_CNTYAMERICANSAMOA           = 684
  #DTWAIN_CNTYANDORRA                 = 033
  #DTWAIN_CNTYANGOLA                 = 1002
  #DTWAIN_CNTYANGUILLA               = 8090
  #DTWAIN_CNTYANTIGUA                = 8091
  #DTWAIN_CNTYARGENTINA                = 54
  #DTWAIN_CNTYARUBA                   = 297
  #DTWAIN_CNTYASCENSIONI              = 247
  #DTWAIN_CNTYAUSTRALIA                = 61
  #DTWAIN_CNTYAUSTRIA                  = 43
  #DTWAIN_CNTYBAHAMAS                = 8092
  #DTWAIN_CNTYBAHRAIN                 = 973
  #DTWAIN_CNTYBANGLADESH              = 880
  #DTWAIN_CNTYBARBADOS               = 8093
  #DTWAIN_CNTYBELGIUM                  = 32
  #DTWAIN_CNTYBELIZE                  = 501
  #DTWAIN_CNTYBENIN                   = 229
  #DTWAIN_CNTYBERMUDA                = 8094
  #DTWAIN_CNTYBHUTAN                 = 1003
  #DTWAIN_CNTYBOLIVIA                 = 591
  #DTWAIN_CNTYBOTSWANA                = 267
  #DTWAIN_CNTYBRITAIN                   = 6
  #DTWAIN_CNTYBRITVIRGINIS           = 8095
  #DTWAIN_CNTYBRAZIL                   = 55
  #DTWAIN_CNTYBRUNEI                  = 673
  #DTWAIN_CNTYBULGARIA                = 359
  #DTWAIN_CNTYBURKINAFASO            = 1004
  #DTWAIN_CNTYBURMA                  = 1005
  #DTWAIN_CNTYBURUNDI                = 1006
  #DTWAIN_CNTYCAMAROON                = 237
  #DTWAIN_CNTYCANADA                    = 2
  #DTWAIN_CNTYCAPEVERDEIS             = 238
  #DTWAIN_CNTYCAYMANIS               = 8096
  #DTWAIN_CNTYCENTRALAFREP           = 1007
  #DTWAIN_CNTYCHAD                   = 1008
  #DTWAIN_CNTYCHILE                    = 56
  #DTWAIN_CNTYCHINA                    = 86
  #DTWAIN_CNTYCHRISTMASIS            = 1009
  #DTWAIN_CNTYCOCOSIS                = 1009
  #DTWAIN_CNTYCOLOMBIA                 = 57
  #DTWAIN_CNTYCOMOROS                = 1010
  #DTWAIN_CNTYCONGO                  = 1011
  #DTWAIN_CNTYCOOKIS                 = 1012
  #DTWAIN_CNTYCOSTARICA              = 506
  #DTWAIN_CNTYCUBA                    = 005
  #DTWAIN_CNTYCYPRUS                  = 357
  #DTWAIN_CNTYCZECHOSLOVAKIA           = 42
  #DTWAIN_CNTYDENMARK                  = 45
  #DTWAIN_CNTYDJIBOUTI               = 1013
  #DTWAIN_CNTYDOMINICA               = 8097
  #DTWAIN_CNTYDOMINCANREP            = 8098
  #DTWAIN_CNTYEASTERIS               = 1014
  #DTWAIN_CNTYECUADOR                 = 593
  #DTWAIN_CNTYEGYPT                    = 20
  #DTWAIN_CNTYELSALVADOR              = 503
  #DTWAIN_CNTYEQGUINEA               = 1015
  #DTWAIN_CNTYETHIOPIA                = 251
  #DTWAIN_CNTYFALKLANDIS             = 1016
  #DTWAIN_CNTYFAEROEIS                = 298
  #DTWAIN_CNTYFIJIISLANDS             = 679
  #DTWAIN_CNTYFINLAND                 = 358
  #DTWAIN_CNTYFRANCE                   = 33
  #DTWAIN_CNTYFRANTILLES              = 596
  #DTWAIN_CNTYFRGUIANA                = 594
  #DTWAIN_CNTYFRPOLYNEISA             = 689
  #DTWAIN_CNTYFUTANAIS               = 1043
  #DTWAIN_CNTYGABON                   = 241
  #DTWAIN_CNTYGAMBIA                  = 220
  #DTWAIN_CNTYGERMANY                  = 49
  #DTWAIN_CNTYGHANA                   = 233
  #DTWAIN_CNTYGIBRALTER               = 350
  #DTWAIN_CNTYGREECE                   = 30
  #DTWAIN_CNTYGREENLAND               = 299
  #DTWAIN_CNTYGRENADA                = 8099
  #DTWAIN_CNTYGRENEDINES             = 8015
  #DTWAIN_CNTYGUADELOUPE              = 590
  #DTWAIN_CNTYGUAM                    = 671
  #DTWAIN_CNTYGUANTANAMOBAY          = 5399
  #DTWAIN_CNTYGUATEMALA               = 502
  #DTWAIN_CNTYGUINEA                  = 224
  #DTWAIN_CNTYGUINEABISSAU           = 1017
  #DTWAIN_CNTYGUYANA                  = 592
  #DTWAIN_CNTYHAITI                   = 509
  #DTWAIN_CNTYHONDURAS                = 504
  #DTWAIN_CNTYHONGKONG               = 852
  #DTWAIN_CNTYHUNGARY                  = 36
  #DTWAIN_CNTYICELAND                 = 354
  #DTWAIN_CNTYINDIA                    = 91
  #DTWAIN_CNTYINDONESIA                = 62
  #DTWAIN_CNTYIRAN                     = 98
  #DTWAIN_CNTYIRAQ                    = 964
  #DTWAIN_CNTYIRELAND                 = 353
  #DTWAIN_CNTYISRAEL                  = 972
  #DTWAIN_CNTYITALY                    = 39
  #DTWAIN_CNTYIVORYCOAST             = 225
  #DTWAIN_CNTYJAMAICA                = 8010
  #DTWAIN_CNTYJAPAN                    = 81
  #DTWAIN_CNTYJORDAN                  = 962
  #DTWAIN_CNTYKENYA                   = 254
  #DTWAIN_CNTYKIRIBATI               = 1018
  #DTWAIN_CNTYKOREA                    = 82
  #DTWAIN_CNTYKUWAIT                  = 965
  #DTWAIN_CNTYLAOS                   = 1019
  #DTWAIN_CNTYLEBANON                = 1020
  #DTWAIN_CNTYLIBERIA                 = 231
  #DTWAIN_CNTYLIBYA                   = 218
  #DTWAIN_CNTYLIECHTENSTEIN            = 41
  #DTWAIN_CNTYLUXENBOURG              = 352
  #DTWAIN_CNTYMACAO                   = 853
  #DTWAIN_CNTYMADAGASCAR             = 1021
  #DTWAIN_CNTYMALAWI                  = 265
  #DTWAIN_CNTYMALAYSIA                 = 60
  #DTWAIN_CNTYMALDIVES                = 960
  #DTWAIN_CNTYMALI                   = 1022
  #DTWAIN_CNTYMALTA                   = 356
  #DTWAIN_CNTYMARSHALLIS              = 692
  #DTWAIN_CNTYMAURITANIA             = 1023
  #DTWAIN_CNTYMAURITIUS               = 230
  #DTWAIN_CNTYMEXICO                    = 3
  #DTWAIN_CNTYMICRONESIA              = 691
  #DTWAIN_CNTYMIQUELON                = 508
  #DTWAIN_CNTYMONACO                   = 33
  #DTWAIN_CNTYMONGOLIA               = 1024
  #DTWAIN_CNTYMONTSERRAT             = 8011
  #DTWAIN_CNTYMOROCCO                 = 212
  #DTWAIN_CNTYMOZAMBIQUE             = 1025
  #DTWAIN_CNTYNAMIBIA                 = 264
  #DTWAIN_CNTYNAURU                  = 1026
  #DTWAIN_CNTYNEPAL                   = 977
  #DTWAIN_CNTYNETHERLANDS              = 31
  #DTWAIN_CNTYNETHANTILLES            = 599
  #DTWAIN_CNTYNEVIS                  = 8012
  #DTWAIN_CNTYNEWCALEDONIA            = 687
  #DTWAIN_CNTYNEWZEALAND               = 64
  #DTWAIN_CNTYNICARAGUA               = 505
  #DTWAIN_CNTYNIGER                   = 227
  #DTWAIN_CNTYNIGERIA                 = 234
  #DTWAIN_CNTYNIUE                   = 1027
  #DTWAIN_CNTYNORFOLKI               = 1028
  #DTWAIN_CNTYNORWAY                   = 47
  #DTWAIN_CNTYOMAN                    = 968
  #DTWAIN_CNTYPAKISTAN                 = 92
  #DTWAIN_CNTYPALAU                  = 1029
  #DTWAIN_CNTYPANAMA                  = 507
  #DTWAIN_CNTYPARAGUAY                = 595
  #DTWAIN_CNTYPERU                     = 51
  #DTWAIN_CNTYPHILLIPPINES             = 63
  #DTWAIN_CNTYPITCAIRNIS             = 1030
  #DTWAIN_CNTYPNEWGUINEA              = 675
  #DTWAIN_CNTYPOLAND                   = 48
  #DTWAIN_CNTYPORTUGAL                = 351
  #DTWAIN_CNTYQATAR                   = 974
  #DTWAIN_CNTYREUNIONI               = 1031
  #DTWAIN_CNTYROMANIA                  = 40
  #DTWAIN_CNTYRWANDA                  = 250
  #DTWAIN_CNTYSAIPAN                  = 670
  #DTWAIN_CNTYSANMARINO                = 39
  #DTWAIN_CNTYSAOTOME                = 1033
  #DTWAIN_CNTYSAUDIARABIA             = 966
  #DTWAIN_CNTYSENEGAL                 = 221
  #DTWAIN_CNTYSEYCHELLESIS           = 1034
  #DTWAIN_CNTYSIERRALEONE            = 1035
  #DTWAIN_CNTYSINGAPORE                = 65
  #DTWAIN_CNTYSOLOMONIS              = 1036
  #DTWAIN_CNTYSOMALI                 = 1037
  #DTWAIN_CNTYSOUTHAFRICA              = 27
  #DTWAIN_CNTYSPAIN                    = 34
  #DTWAIN_CNTYSRILANKA                 = 94
  #DTWAIN_CNTYSTHELENA               = 1032
  #DTWAIN_CNTYSTKITTS                = 8013
  #DTWAIN_CNTYSTLUCIA                = 8014
  #DTWAIN_CNTYSTPIERRE                = 508
  #DTWAIN_CNTYSTVINCENT              = 8015
  #DTWAIN_CNTYSUDAN                  = 1038
  #DTWAIN_CNTYSURINAME                = 597
  #DTWAIN_CNTYSWAZILAND               = 268
  #DTWAIN_CNTYSWEDEN                   = 46
  #DTWAIN_CNTYSWITZERLAND              = 41
  #DTWAIN_CNTYSYRIA                  = 1039
  #DTWAIN_CNTYTAIWAN                  = 886
  #DTWAIN_CNTYTANZANIA                = 255
  #DTWAIN_CNTYTHAILAND                 = 66
  #DTWAIN_CNTYTOBAGO                 = 8016
  #DTWAIN_CNTYTOGO                    = 228
  #DTWAIN_CNTYTONGAIS                 = 676
  #DTWAIN_CNTYTRINIDAD               = 8016
  #DTWAIN_CNTYTUNISIA                 = 216
  #DTWAIN_CNTYTURKEY                   = 90
  #DTWAIN_CNTYTURKSCAICOS            = 8017
  #DTWAIN_CNTYTUVALU                 = 1040
  #DTWAIN_CNTYUGANDA                  = 256
  #DTWAIN_CNTYUSSR                      = 7
  #DTWAIN_CNTYUAEMIRATES              = 971
  #DTWAIN_CNTYUNITEDKINGDOM            = 44
  #DTWAIN_CNTYUSA                       = 1
  #DTWAIN_CNTYURUGUAY                 = 598
  #DTWAIN_CNTYVANUATU                = 1041
  #DTWAIN_CNTYVATICANCITY              = 39
  #DTWAIN_CNTYVENEZUELA                = 58
  #DTWAIN_CNTYWAKE                   = 1042
  #DTWAIN_CNTYWALLISIS               = 1043
  #DTWAIN_CNTYWESTERNSAHARA          = 1044
  #DTWAIN_CNTYWESTERNSAMOA           = 1045
  #DTWAIN_CNTYYEMEN                  = 1046
  #DTWAIN_CNTYYUGOSLAVIA               = 38
  #DTWAIN_CNTYZAIRE                   = 243
  #DTWAIN_CNTYZAMBIA                  = 260
  #DTWAIN_CNTYZIMBABWE                = 263
  
  
  ; Language information 
  #DTWAIN_LANGDANISH                    = 0
  #DTWAIN_LANGDUTCH                     = 1
  #DTWAIN_LANGINTERNATIONALENGLISH      = 2
  #DTWAIN_LANGFRENCHCANADIAN            = 3
  #DTWAIN_LANGFINNISH                   = 4
  #DTWAIN_LANGFRENCH                    = 5
  #DTWAIN_LANGGERMAN                    = 6
  #DTWAIN_LANGICELANDIC                 = 7
  #DTWAIN_LANGITALIAN                   = 8
  #DTWAIN_LANGNORWEGIAN                 = 9
  #DTWAIN_LANGPORTUGUESE               = 10
  #DTWAIN_LANGSPANISH                  = 11
  #DTWAIN_LANGSWEDISH                  = 12
  #DTWAIN_LANGUSAENGLISH               = 13
  
  ;= #DTWAIN API And Twain status flags 
  #DTWAIN_APIHANDLEOK                   = 1
  #DTWAIN_TWAINSESSIONOK                = 2
  
  ; Error codes= (returned by= #DTWAIN_GetLastError() 
  #DTWAIN_NO_ERROR              = (0)
  #DTWAIN_ERR_FIRST             = (-1000)
  #DTWAIN_ERR_BAD_HANDLE        = (-1001)
  #DTWAIN_ERR_BAD_SOURCE        = (-1002)
  #DTWAIN_ERR_BAD_ARRAY         = (-1003)
  #DTWAIN_ERR_WRONG_ARRAY_TYPE  = (-1004)
  #DTWAIN_ERR_INDEX_BOUNDS      = (-1005)
  #DTWAIN_ERR_OUT_OF_MEMORY     = (-1006)
  #DTWAIN_ERR_NULL_WINDOW       = (-1007)
  #DTWAIN_ERR_BAD_PIXTYPE       = (-1008)
  #DTWAIN_ERR_BAD_CONTAINER     = (-1009)
  #DTWAIN_ERR_NO_SESSION        = (-1010)
  #DTWAIN_ERR_BAD_ACQUIRE_NUM   = (-1011)
  #DTWAIN_ERR_BAD_CAP           = (-1012)
  #DTWAIN_ERR_CAP_NO_SUPPORT    = (-1013)
  #DTWAIN_ERR_TWAIN             = (-1014)
  #DTWAIN_ERR_HOOK_FAILED       = (-1015)
  #DTWAIN_ERR_BAD_FILENAME      = (-1016)
  #DTWAIN_ERR_EMPTY_ARRAY       = (-1017)
  #DTWAIN_ERR_FILE_FORMAT       = (-1018)
  #DTWAIN_ERR_BAD_DIB_PAGE      = (-1019)
  #DTWAIN_ERR_SOURCE_ACQUIRING  = (-1020)
  #DTWAIN_ERR_INVALID_PARAM     = (-1021)
  #DTWAIN_ERR_INVALID_RANGE     = (-1022)
  #DTWAIN_ERR_UI_ERROR          = (-1023)
  #DTWAIN_ERR_BAD_UNIT          = (-1024)
  #DTWAIN_ERR_LANGDLL_NOT_FOUND = (-1025)
  #DTWAIN_ERR_SOURCE_NOT_OPEN   = (-1026)
  #DTWAIN_ERR_DEVICEEVENT_NOT_SUPPORTED= (-1027)
  #DTWAIN_ERR_UIONLY_NOT_SUPPORTED= (-1028)
  #DTWAIN_ERR_UI_ALREADY_OPENED = (-1029)
  #DTWAIN_ERR_CAPSET_NOSUPPORT  = (-1030)
  #DTWAIN_ERR_NO_FILE_XFER      = (-1031)
  #DTWAIN_ERR_INVALID_BITDEPTH  = (-1032)
  #DTWAIN_ERR_NO_CAPS_DEFINED   = (-1033)
  #DTWAIN_ERR_TILES_NOT_SUPPORTED= (-1034)
  #DTWAIN_ERR_INVALID_DTWAIN_FRAME= (-1035)
  #DTWAIN_ERR_LIMITED_VERSION   = (-1036)
  #DTWAIN_ERR_NO_FEEDER         = (-1037)
  #DTWAIN_ERR_NO_FEEDER_QUERY   = (-1038)
  #DTWAIN_ERR_EXCEPTION_ERROR   = (-1039)
  #DTWAIN_ERR_INVALID_STATE     = (-1040)
  #DTWAIN_ERR_UNSUPPORTED_EXTINFO= (-1041)
  #DTWAIN_ERR_DLLRESOURCE_NOTFOUND= (-1042)
  #DTWAIN_ERR_NOT_INITIALIZED   = (-1043)
  #DTWAIN_ERR_NO_SOURCES        = (-1044)
  #DTWAIN_ERR_TWAIN_NOT_INSTALLED= (-1045)
  #DTWAIN_ERR_WRONG_THREAD      = (-1046)
  #DTWAIN_ERR_BAD_CAPTYPE       = (-1047)
  #DTWAIN_ERR_UNKNOWN_CAPDATATYPE  = (-1048)
  #DTWAIN_ERR_DEMO_NOFILETYPE   = (-1049)
  #DTWAIN_ERR_SOURCESELECTION_CANCELED= (-1050)
  #DTWAIN_ERR_RESOURCES_NOT_FOUND= (-1051)
  #DTWAIN_ERR_STRINGTYPE_MISMATCH= (-1052)
  #DTWAIN_ERR_ARRAYTYPE_MISMATCH= (-1053)
  #DTWAIN_ERR_SOURCENAME_NOTINSTALLED= (-1054)
  #DTWAIN_ERR_NO_MEMFILE_XFER   = (-1055)
  
  #DTWAIN_ERR_LAST_1      = #DTWAIN_ERR_DEMO_NOFILETYPE
  
  #TWAIN_ERR_LOW_MEMORY       = (-1100)
  #TWAIN_ERR_FALSE_ALARM      = (-1101)
  #TWAIN_ERR_BUMMER           = (-1102)
  #TWAIN_ERR_NODATASOURCE     = (-1103)
  #TWAIN_ERR_MAXCONNECTIONS   = (-1104)
  #TWAIN_ERR_OPERATIONERROR   = (-1105)
  #TWAIN_ERR_BADCAPABILITY    = (-1106)
  #TWAIN_ERR_BADVALUE         = (-1107)
  #TWAIN_ERR_BADPROTOCOL      = (-1108)
  #TWAIN_ERR_SEQUENCEERROR    = (-1109)
  #TWAIN_ERR_BADDESTINATION   = (-1110)
  #TWAIN_ERR_CAPNOTSUPPORTED  = (-1111)
  #TWAIN_ERR_CAPBADOPERATION  = (-1112)
  #TWAIN_ERR_CAPSEQUENCEERROR = (-1113)
  #TWAIN_ERR_FILEPROTECTEDERROR = (-1114)
  #TWAIN_ERR_FILEEXISTERROR     = (-1115)
  #TWAIN_ERR_FILENOTFOUND       = (-1116)
  #TWAIN_ERR_DIRNOTEMPTY        = (-1117)
  #TWAIN_ERR_FEEDERJAMMED       = (-1118)
  #TWAIN_ERR_FEEDERMULTPAGES    = (-1119)
  #TWAIN_ERR_FEEDERWRITEERROR   = (-1120)
  #TWAIN_ERR_DEVICEOFFLINE      = (-1121)
  #TWAIN_ERR_NULL_CONTAINER     = (-1122)
  #TWAIN_ERR_INTERLOCK          = (-1123)
  #TWAIN_ERR_DAMAGEDCORNER      = (-1124)
  #TWAIN_ERR_FOCUSERROR         = (-1125)
  #TWAIN_ERR_DOCTOOLIGHT        = (-1126)
  #TWAIN_ERR_DOCTOODARK         = (-1127)
  #TWAIN_ERR_NOMEDIA            = (-1128)
  
  ; File errors generated when calling= #DTWAIN_AcquireFile Or= #DTWAIN_AcquireFileEx 
  #DTWAIN_ERR_FILEXFERSTART   = (-2000)
  #DTWAIN_ERR_MEM             = (-2001)
  #DTWAIN_ERR_FILEOPEN        = (-2002)
  #DTWAIN_ERR_FILEREAD        = (-2003)
  #DTWAIN_ERR_FILEWRITE       = (-2004)
  #DTWAIN_ERR_BADPARAM        = (-2005)
  #DTWAIN_ERR_INVALIDBMP      = (-2006)
  #DTWAIN_ERR_BMPRLE          = (-2007)
  #DTWAIN_ERR_RESERVED1       = (-2008)
  #DTWAIN_ERR_INVALIDJPG      = (-2009)
  #DTWAIN_ERR_DC              = (-2010)
  #DTWAIN_ERR_DIB             = (-2011)
  #DTWAIN_ERR_RESERVED2       = (-2012)
  #DTWAIN_ERR_NORESOURCE      = (-2013)
  #DTWAIN_ERR_CALLBACKCANCEL  = (-2014)
  #DTWAIN_ERR_INVALIDPNG      = (-2015)
  #DTWAIN_ERR_PNGCREATE       = (-2016)
  #DTWAIN_ERR_INTERNAL        = (-2017)
  #DTWAIN_ERR_FONT            = (-2018)
  #DTWAIN_ERR_INTTIFF         = (-2019)
  #DTWAIN_ERR_INVALIDTIFF     = (-2020)
  #DTWAIN_ERR_NOTIFFLZW       = (-2021)
  #DTWAIN_ERR_INVALIDPCX      = (-2022)
  #DTWAIN_ERR_CREATEBMP       = (-2023)
  #DTWAIN_ERR_NOLINES         = (-2024)
  #DTWAIN_ERR_GETDIB          = (-2025)
  #DTWAIN_ERR_NODEVOP         = (-2026)
  #DTWAIN_ERR_INVALIDWMF      = (-2027)
  #DTWAIN_ERR_DEPTHMISMATCH   = (-2028)
  #DTWAIN_ERR_BITBLT          = (-2029)
  #DTWAIN_ERR_BUFTOOSMALL     = (-2030)
  #DTWAIN_ERR_TOOMANYCOLORS   = (-2031)
  #DTWAIN_ERR_INVALIDTGA      = (-2032)
  #DTWAIN_ERR_NOTGATHUMBNAIL  = (-2033)
  #DTWAIN_ERR_RESERVED3       = (-2034)
  #DTWAIN_ERR_CREATEDIB       = (-2035)
  #DTWAIN_ERR_NOLZW           = (-2036)
  #DTWAIN_ERR_SELECTOBJ       = (-2037)
  #DTWAIN_ERR_BADMANAGER      = (-2038)
  #DTWAIN_ERR_OBSOLETE        = (-2039)
  #DTWAIN_ERR_CREATEDIBSECTION       = (-2040)
  #DTWAIN_ERR_SETWINMETAFILEBITS     = (-2041)
  #DTWAIN_ERR_GETWINMETAFILEBITS     = (-2042)
  #DTWAIN_ERR_PAXPWD                 = (-2043)
  #DTWAIN_ERR_INVALIDPAX             = (-2044)
  #DTWAIN_ERR_NOSUPPORT              = (-2045)
  #DTWAIN_ERR_INVALIDPSD             = (-2046)
  #DTWAIN_ERR_PSDNOTSUPPORTED        = (-2047)
  #DTWAIN_ERR_DECRYPT                = (-2048)
  #DTWAIN_ERR_ENCRYPT                = (-2049)
  #DTWAIN_ERR_COMPRESSION            = (-2050)
  #DTWAIN_ERR_DECOMPRESSION          = (-2051)
  #DTWAIN_ERR_INVALIDTLA             = (-2052)
  #DTWAIN_ERR_INVALIDWBMP            = (-2053)
  #DTWAIN_ERR_NOTIFFTAG              = (-2054)
  #DTWAIN_ERR_NOLOCALSTORAGE         = (-2055)
  #DTWAIN_ERR_INVALIDEXIF            = (-2056)
  #DTWAIN_ERR_NOEXIFSTRING           = (-2057)
  #DTWAIN_ERR_TIFFDLL32NOTFOUND      = (-2058)
  #DTWAIN_ERR_TIFFDLL16NOTFOUND      = (-2059)
  #DTWAIN_ERR_PNGDLL16NOTFOUND       = (-2060)
  #DTWAIN_ERR_JPEGDLL16NOTFOUND      = (-2061)
  #DTWAIN_ERR_BADBITSPERPIXEL        = (-2062)
  #DTWAIN_ERR_TIFFDLL32INVALIDVER    = (-2063)
  #DTWAIN_ERR_PDFDLL32NOTFOUND       = (-2064)
  #DTWAIN_ERR_PDFDLL32INVALIDVER     = (-2065)
  #DTWAIN_ERR_JPEGDLL32NOTFOUND      = (-2066)
  #DTWAIN_ERR_JPEGDLL32INVALIDVER    = (-2067)
  #DTWAIN_ERR_PNGDLL32NOTFOUND       = (-2068)
  #DTWAIN_ERR_PNGDLL32INVALIDVER     = (-2069)
  #DTWAIN_ERR_J2KDLL32NOTFOUND       = (-2070)
  #DTWAIN_ERR_J2KDLL32INVALIDVER     = (-2071)
  #DTWAIN_ERR_MANDUPLEX_UNAVAILABLE  = (-2072)
  #DTWAIN_ERR_TIMEOUT                = (-2073)
  #DTWAIN_ERR_INVALIDICONFORMAT      = (-2074)
  #DTWAIN_ERR_TWAIN32DSMNOTFOUND     = (-2075)
  #DTWAIN_ERR_TWAINOPENSOURCEDSMNOTFOUND= (-2076)
  #DTWAIN_ERR_INVALID_DIRECTORY      = (-2077)
  #DTWAIN_ERR_CREATE_DIRECTORY       = (-2078)
  
  ; TwainSave errors 
  #DTWAIN_TWAINSAVE_OK               = (0)
  #DTWAIN_ERR_TS_FIRST               = (-2080)
  #DTWAIN_ERR_TS_NOFILENAME          = (-2081)
  #DTWAIN_ERR_TS_NOTWAINSYS          = (-2082)
  #DTWAIN_ERR_TS_DEVICEFAILURE       = (-2083)
  #DTWAIN_ERR_TS_FILESAVEERROR       = (-2084)
  #DTWAIN_ERR_TS_COMMANDILLEGAL      = (-2085)
  #DTWAIN_ERR_TS_CANCELLED           = (-2086)
  #DTWAIN_ERR_TS_ACQUISITIONERROR    = (-2087)
  #DTWAIN_ERR_TS_INVALIDCOLORSPACE   = (-2088)
  #DTWAIN_ERR_TS_PDFNOTSUPPORTED     = (-2089)
  #DTWAIN_ERR_TS_NOTAVAILABLE        = (-2090)
  
  ; OCR errors 
  #DTWAIN_ERR_OCR_FIRST              = (-2100)
  #DTWAIN_ERR_OCR_INVALIDPAGENUM     = (-2101)
  #DTWAIN_ERR_OCR_INVALIDENGINE      = (-2102)
  #DTWAIN_ERR_OCR_NOTACTIVE          = (-2103)
  #DTWAIN_ERR_OCR_INVALIDFILETYPE    = (-2104)
  #DTWAIN_ERR_OCR_INVALIDPIXELTYPE   = (-2105)
  #DTWAIN_ERR_OCR_INVALIDBITDEPTH    = (-2106)
  #DTWAIN_ERR_OCR_RECOGNITIONERROR   = (-2107)
  #DTWAIN_ERR_OCR_LAST               = (-2108)
  #DTWAIN_ERR_SOURCE_COULD_NOT_OPEN  = (-2500)
  #DTWAIN_ERR_SOURCE_COULD_NOT_CLOSE = (-2501)
  
  #DTWAIN_ERR_LAST                   = #DTWAIN_ERR_SOURCE_COULD_NOT_CLOSE
  #DTWAIN_ERR_USER_START             = (-80000)  
  
  ; Device event constants= (same As TWAIN= 1.8 value plus= 1)
  #DTWAIN_DE_CHKAUTOCAPTURE   = 1
  #DTWAIN_DE_CHKBATTERY       = 2
  #DTWAIN_DE_CHKDEVICEONLINE  = 4
  #DTWAIN_DE_CHKFLASH         = 8
  #DTWAIN_DE_CHKPOWERSUPPLY   = 16
  #DTWAIN_DE_CHKRESOLUTION    = 32
  #DTWAIN_DE_DEVICEADDED      = 64
  #DTWAIN_DE_DEVICEOFFLINE    = 128
  #DTWAIN_DE_DEVICEREADY      = 256
  #DTWAIN_DE_DEVICEREMOVED    = 512
  #DTWAIN_DE_IMAGECAPTURED    = 1024
  #DTWAIN_DE_IMAGEDELETED     = 2048
  #DTWAIN_DE_PAPERDOUBLEFEED  = 4096
  #DTWAIN_DE_PAPERJAM         = 8192
  #DTWAIN_DE_LAMPFAILURE      = 16384
  #DTWAIN_DE_POWERSAVE        = 32768
  #DTWAIN_DE_POWERSAVENOTIFY  = 65536
  #DTWAIN_DE_CUSTOMEVENTS     = $8000
  
  ;= #DTWAIN Constants used For getting Device Event Info
  #DTWAIN_GETDE_EVENT          = 0
  #DTWAIN_GETDE_DEVNAME        = 1
  #DTWAIN_GETDE_BATTERYMINUTES = 2
  #DTWAIN_GETDE_BATTERYPCT     = 3
  #DTWAIN_GETDE_XRESOLUTION    = 4
  #DTWAIN_GETDE_YRESOLUTION    = 5
  #DTWAIN_GETDE_FLASHUSED      = 6
  #DTWAIN_GETDE_AUTOCAPTURE    = 7
  #DTWAIN_GETDE_TIMEBEFORECAPTURE= 8
  #DTWAIN_GETDE_TIMEBETWEENCAPTURES = 9
  #DTWAIN_GETDE_POWERSUPPLY     = 10
  
  ;= #DTWAIN Imprinter/Endorser Constants = (TWAIN= 1.8 values)
  #DTWAIN_IMPRINTERTOPBEFORE    = 1   ;(0)
  #DTWAIN_IMPRINTERTOPAFTER     = 2   ;(1)
  #DTWAIN_IMPRINTERBOTTOMBEFORE = 4   ;(2)
  #DTWAIN_IMPRINTERBOTTOMAFTER  = 8   ;(3)
  #DTWAIN_ENDORSERTOPBEFORE     = 16  ;(4)
  #DTWAIN_ENDORSERTOPAFTER      = 32  ;(5)
  #DTWAIN_ENDORSERBOTTOMBEFORE  = 64  ;(6)
  #DTWAIN_ENDORSERBOTTOMAFTER   = 128 ;(7)
  
  #DTWAIN_TWPR_IMPRINTERTOPBEFORE    = 0
  #DTWAIN_TWPR_IMPRINTERTOPAFTER     = 1
  #DTWAIN_TWPR_IMPRINTERBOTTOMBEFORE = 2
  #DTWAIN_TWPR_IMPRINTERBOTTOMAFTER  = 3
  #DTWAIN_TWPR_ENDORSERTOPBEFORE     = 4
  #DTWAIN_TWPR_ENDORSERTOPAFTER      = 5
  #DTWAIN_TWPR_ENDORSERBOTTOMBEFORE  = 6
  #DTWAIN_TWPR_ENDORSERBOTTOMAFTER   = 7
  
  ;= #DTWAIN Printermode constants= (same As TWAIN= 1.8) 
  #DTWAIN_PM_SINGLESTRING    = 0
  #DTWAIN_PM_MULTISTRING     = 1
  #DTWAIN_PM_COMPOUNDSTRING  = 2
  
  ; TWAIN Data Types 
  #DTWAIN_TWTY_INT8       = $0000
  #DTWAIN_TWTY_INT16      = $0001
  #DTWAIN_TWTY_INT32      = $0002
  #DTWAIN_TWTY_UINT8      = $0003
  #DTWAIN_TWTY_UINT16     = $0004
  #DTWAIN_TWTY_UINT32     = $0005
  #DTWAIN_TWTY_BOOL       = $0006
  #DTWAIN_TWTY_FIX32      = $0007
  #DTWAIN_TWTY_FRAME      = $0008
  #DTWAIN_TWTY_STR32      = $0009
  #DTWAIN_TWTY_STR64      = $000A
  #DTWAIN_TWTY_STR128     = $000B
  #DTWAIN_TWTY_STR255     = $000C
  #DTWAIN_TWTY_STR1024    = $000D
  #DTWAIN_TWTY_UNI512     = $000E
  
  ; Extended image attributes 
  #DTWAIN_EI_BARCODEX              = $1200
  #DTWAIN_EI_BARCODEY              = $1201
  #DTWAIN_EI_BARCODETEXT           = $1202
  #DTWAIN_EI_BARCODETYPE           = $1203
  #DTWAIN_EI_DESHADETOP            = $1204
  #DTWAIN_EI_DESHADELEFT           = $1205
  #DTWAIN_EI_DESHADEHEIGHT         = $1206
  #DTWAIN_EI_DESHADEWIDTH          = $1207
  #DTWAIN_EI_DESHADESIZE           = $1208
  #DTWAIN_EI_SPECKLESREMOVED       = $1209
  #DTWAIN_EI_HORZLINEXCOORD        = $120A
  #DTWAIN_EI_HORZLINEYCOORD        = $120B
  #DTWAIN_EI_HORZLINELENGTH        = $120C
  #DTWAIN_EI_HORZLINETHICKNESS     = $120D
  #DTWAIN_EI_VERTLINEXCOORD        = $120E
  #DTWAIN_EI_VERTLINEYCOORD        = $120F
  #DTWAIN_EI_VERTLINELENGTH        = $1210
  #DTWAIN_EI_VERTLINETHICKNESS     = $1211
  #DTWAIN_EI_PATCHCODE             = $1212
  #DTWAIN_EI_ENDORSEDTEXT          = $1213
  #DTWAIN_EI_FORMCONFIDENCE        = $1214
  #DTWAIN_EI_FORMTEMPLATEMATCH     = $1215
  #DTWAIN_EI_FORMTEMPLATEPAGEMATCH = $1216
  #DTWAIN_EI_FORMHORZDOCOFFSET     = $1217
  #DTWAIN_EI_FORMVERTDOCOFFSET     = $1218
  #DTWAIN_EI_BARCODECOUNT          = $1219
  #DTWAIN_EI_BARCODECONFIDENCE     = $121A
  #DTWAIN_EI_BARCODEROTATION       = $121B
  #DTWAIN_EI_BARCODETEXTLENGTH     = $121C
  #DTWAIN_EI_DESHADECOUNT          = $121D
  #DTWAIN_EI_DESHADEBLACKCOUNTOLD  = $121E
  #DTWAIN_EI_DESHADEBLACKCOUNTNEW  = $121F
  #DTWAIN_EI_DESHADEBLACKRLMIN     = $1220
  #DTWAIN_EI_DESHADEBLACKRLMAX     = $1221
  #DTWAIN_EI_DESHADEWHITECOUNTOLD  = $1222
  #DTWAIN_EI_DESHADEWHITECOUNTNEW  = $1223
  #DTWAIN_EI_DESHADEWHITERLMIN     = $1224
  #DTWAIN_EI_DESHADEWHITERLAVE     = $1225
  #DTWAIN_EI_DESHADEWHITERLMAX     = $1226
  #DTWAIN_EI_BLACKSPECKLESREMOVED  = $1227
  #DTWAIN_EI_WHITESPECKLESREMOVED  = $1228
  #DTWAIN_EI_HORZLINECOUNT         = $1229
  #DTWAIN_EI_VERTLINECOUNT         = $122A
  #DTWAIN_EI_DESKEWSTATUS          = $122B
  #DTWAIN_EI_SKEWORIGINALANGLE     = $122C
  #DTWAIN_EI_SKEWFINALANGLE        = $122D
  #DTWAIN_EI_SKEWCONFIDENCE        = $122E
  #DTWAIN_EI_SKEWWINDOWX1          = $122F
  #DTWAIN_EI_SKEWWINDOWY1          = $1230
  #DTWAIN_EI_SKEWWINDOWX2          = $1231
  #DTWAIN_EI_SKEWWINDOWY2          = $1232
  #DTWAIN_EI_SKEWWINDOWX3          = $1233
  #DTWAIN_EI_SKEWWINDOWY3          = $1234
  #DTWAIN_EI_SKEWWINDOWX4          = $1235
  #DTWAIN_EI_SKEWWINDOWY4          = $1236
  #DTWAIN_EI_BOOKNAME              = $1238
  #DTWAIN_EI_CHAPTERNUMBER         = $1239
  #DTWAIN_EI_DOCUMENTNUMBER        = $123A
  #DTWAIN_EI_PAGENUMBER            = $123B
  #DTWAIN_EI_CAMERA                = $123C
  #DTWAIN_EI_FRAMENUMBER           = $123D
  #DTWAIN_EI_FRAME                 = $123E
  #DTWAIN_EI_PIXELFLAVOR           = $123F
  #DTWAIN_EI_ICCPROFILE            = $1240
  #DTWAIN_EI_LASTSEGMENT           = $1241
  #DTWAIN_EI_SEGMENTNUMBER         = $1242
  #DTWAIN_EI_MAGDATA               = $1243
  #DTWAIN_EI_MAGTYPE               = $1244
  #DTWAIN_EI_PAGESIDE              = $1245
  #DTWAIN_EI_FILESYSTEMSOURCE      = $1246
  #DTWAIN_EI_IMAGEMERGED           = $1247
  #DTWAIN_EI_MAGDATALENGTH         = $1248
  #DTWAIN_EI_PAPERCOUNT            = $1249
  #DTWAIN_EI_PRINTERTEXT           = $124A
  #DTWAIN_EI_TWAINDIRECTMETADATA   = $124B
  
  ; TWAIN Data Source Error logging functions 
  #DTWAIN_LOG_DECODE_SOURCE     = $00000001
  #DTWAIN_LOG_DECODE_DEST       = $00000002
  #DTWAIN_LOG_DECODE_TWMEMREF   = $00000004
  #DTWAIN_LOG_DECODE_TWEVENT    = $00000008
  
  ;= #DTWAIN Call stack logging 
  #DTWAIN_LOG_CALLSTACK         = $00000010
  
  ;= #DTWAIN LOG= #DTWAIN_IsTwainMsg
  ; Note that enabling this will produce very large log files.
  
  #DTWAIN_LOG_ISTWAINMSG        = $00000020
  
  ; Display message If= #DTWAIN function called on bad DLL
  ; If this flag is not set, calls To an uninitialized
  ;= #DTWAIN DLL are not displayed 
  #DTWAIN_LOG_INITFAILURE       = $00000040
  
  ; All other lower-level TWAIN activity
  #DTWAIN_LOG_LOWLEVELTWAIN     = $00000080
  
  ; Decode bitmap info returned by TWAIN device when acquiring images
  #DTWAIN_LOG_DECODE_BITMAP     = $00000100
  
  ; Log= #DTWAIN_TN_ notifications  
  #DTWAIN_LOG_NOTIFICATIONS     = $00000200
  
  ; All other= #DTWAIN information such As CAP listings, etc.
  #DTWAIN_LOG_MISCELLANEOUS     = $00000400
  
  ; Any= #DTWAIN errors= (Not TWAIN related) 
  #DTWAIN_LOG_DTWAINERRORS      = $00000800
  
  #DTWAIN_LOG_ALL= (#DTWAIN_LOG_DECODE_SOURCE | #DTWAIN_LOG_DECODE_DEST | #DTWAIN_LOG_DECODE_TWEVENT | #DTWAIN_LOG_DECODE_TWMEMREF | #DTWAIN_LOG_CALLSTACK | #DTWAIN_LOG_ISTWAINMSG | #DTWAIN_LOG_INITFAILURE | #DTWAIN_LOG_LOWLEVELTWAIN | #DTWAIN_LOG_NOTIFICATIONS | #DTWAIN_LOG_MISCELLANEOUS | #DTWAIN_LOG_DTWAINERRORS | #DTWAIN_LOG_DECODE_BITMAP)
  
  ; ------------------------- 
  
  ;= #DTWAIN Log To a file 
  #DTWAIN_LOG_USEFILE        = $00010000
  
  ; log exception errors To message boxes 
  #DTWAIN_LOG_SHOWEXCEPTIONS = $00020000
  
  ; Display standard message box If= #DTWAIN error 
  #DTWAIN_LOG_ERRORMSGBOX    = $00040000
  
  ; Log errors To a buffer of all= #DTWAIN errors 
  #DTWAIN_LOG_USEBUFFER      = $00080000
  
  ; Append To log file 
  #DTWAIN_LOG_FILEAPPEND     = $00100000
  
  ; If this flag is ON, a callback function is invoked 
  #DTWAIN_LOG_USECALLBACK    = $00200000
  
  ; If cr/lf is added To End of log message when writing To
  ; Debug monitor, this flag is ON 
  #DTWAIN_LOG_USECRLF        = $00400000
  
  ; Log To the console 
  #DTWAIN_LOG_CONSOLE        = $00800000
  
  ; Log To Debug monitor 
  #DTWAIN_LOG_DEBUGMONITOR   = $01000000
  
  ;= #DTWAIN Log To window= (Not yet implemented) 
  #DTWAIN_LOG_USEWINDOW      = $02000000
  
  ; log everything, including displaying exceptions 
  #DTWAIN_LOG_ALL_NOCALLBACK  = (#DTWAIN_LOG_ALL & ~#DTWAIN_LOG_USECALLBACK)
  
  ; log everything using new log file 
  #DTWAIN_LOG_ALL_FILEAPPEND   = (#DTWAIN_LOG_FILEAPPEND | #DTWAIN_LOG_ALL)
  
  ; turn off the= #DTWAIN_IsTwainMsg logging 
  ;#DTWAIN_LOG_NOISTWAINMSG(x) { If= ((x) |= #DTWAIN_LOG_ISTWAINMSG)= (x) &= ~DTWAIN_LOG_ISTWAINMSG; }
  ;#DTWAIN_LOG_NOLOWLEVELTWAIN(x) {= (x) &= ~(DTWAIN_LOG_LOWLEVELTWAIN); }
  
  ; CAP_CUSTOMDSDATA constants 
  #DTWAINGCD_RETURNHANDLE     = 1
  #DTWAINGCD_COPYDATA         = 2
  
  ;= #DTWAIN Search constants 
  #DTWAIN_BYPOSITION          = 0
  #DTWAIN_BYID                = 1
  
  #DTWAINSCD_USEHANDLE        = 1
  #DTWAINSCD_USEDATA          = 2
  
  ;= #DTWAIN Page Failure Action constants 
  #DTWAIN_PAGEFAIL_RETRY      = 1
  #DTWAIN_PAGEFAIL_TERMINATE  = 2
  #DTWAIN_MAXRETRY_ATTEMPTS   = 3 ; Can be set by= #DTWAIN_SetMaxRetryAttempts() 
  #DTWAIN_RETRY_FOREVER       = (-1)
  
  ; PDF page settings 
  #DTWAIN_PDF_NOSCALING         = 128  ; Places image As-is on PDF page 
  #DTWAIN_PDF_FITPAGE           = 256  ; Fits the image into the page size 
  #DTWAIN_PDF_VARIABLEPAGESIZE  = 512  ; PDF page is determined by acquired page. 
  #DTWAIN_PDF_CUSTOMSIZE        = 1024 ; Page size is custom 
  #DTWAIN_PDF_USECOMPRESSION    = 2048 ; Use zlib compression 
  #DTWAIN_PDF_CUSTOMSCALE       = 4096 ; Custom scaling value 
  #DTWAIN_PDF_PIXELSPERMETERSIZE= 8192 ; Determine PDF page size given image bit depth,
                                       ; image dimensions, And pixels per meter setting 
  
  ; PDF encryption settings 
  #DTWAIN_PDF_ALLOWPRINTING       = 2052 ;= (2048 += 4) 
  #DTWAIN_PDF_ALLOWMOD            = 8
  #DTWAIN_PDF_ALLOWCOPY           = 16
  #DTWAIN_PDF_ALLOWMODANNOTATIONS = 32
  #DTWAIN_PDF_ALLOWFILLIN         = 256
  #DTWAIN_PDF_ALLOWEXTRACTION     = 512
  #DTWAIN_PDF_ALLOWASSEMBLY       = 1024
  #DTWAIN_PDF_ALLOWDEGRADEDPRINTING= 4
  
  ; PDF Orientation 
  #DTWAIN_PDF_PORTRAIT        = 0
  #DTWAIN_PDF_LANDSCAPE       = 1
  
  
  ; Postscript options 
  #DTWAIN_PS_REGULAR          = 0
  #DTWAIN_PS_ENCAPSULATED     = 1
  
  ; Blank page detection options 
  #DTWAIN_BP_AUTODISCARD_NONE         = 0
  #DTWAIN_BP_AUTODISCARD_IMMEDIATE    = 1
  #DTWAIN_BP_AUTODISCARD_AFTERPROCESS = 2
  #DTWAIN_BP_DETECTORIGINAL           = 1
  #DTWAIN_BP_DETECTADJUSTED           = 2
  #DTWAIN_BP_DETECTALL                = (#DTWAIN_BP_DETECTORIGINAL | #DTWAIN_BP_DETECTADJUSTED)
  #DTWAIN_BP_AUTODISCARD_ANY          = $FFFF
  
  ; Lightpath 
  #DTWAIN_LP_REFLECTIVE       = 0
  #DTWAIN_LP_TRANSMISSIVE     = 1
  
  ; Light Source 
  #DTWAIN_LS_RED              = 0
  #DTWAIN_LS_GREEN            = 1
  #DTWAIN_LS_BLUE             = 2
  #DTWAIN_LS_NONE             = 3
  #DTWAIN_LS_WHITE            = 4
  #DTWAIN_LS_UV               = 5
  #DTWAIN_LS_IR               = 6
  
  ;= #DTWAIN Twain dialog options 
  #DTWAIN_DLG_SORTNAMES           = 1
  #DTWAIN_DLG_CENTER              = 2
  #DTWAIN_DLG_CENTER_SCREEN       = 4
  #DTWAIN_DLG_USETEMPLATE         = 8
  #DTWAIN_DLG_CLEAR_PARAMS        = 16
  #DTWAIN_DLG_HORIZONTALSCROLL    = 32
  #DTWAIN_DLG_USEINCLUDENAMES     = 64
  #DTWAIN_DLG_USEEXCLUDENAMES     = 128
  #DTWAIN_DLG_USENAMEMAPPING      = 256
  #DTWAIN_DLG_USEDEFAULTTITLE     = 512
  #DTWAIN_DLG_TOPMOSTWINDOW       = 1024
  
  ;= #DTWAIN Language resource constants 
  #DTWAIN_RES_ENGLISH             = 0
  #DTWAIN_RES_FRENCH              = 1
  #DTWAIN_RES_SPANISH             = 2
  #DTWAIN_RES_DUTCH               = 3
  #DTWAIN_RES_GERMAN              = 4
  #DTWAIN_RES_ITALIAN             = 5
  
  ;= #DTWAIN Alarm constants 
  #DTWAIN_AL_ALARM            = 0
  #DTWAIN_AL_FEEDERERROR      = 1
  #DTWAIN_AL_FEEDERWARNING    = 2
  #DTWAIN_AL_BARCODE          = 3
  #DTWAIN_AL_DOUBLEFEED       = 4
  #DTWAIN_AL_JAM              = 5
  #DTWAIN_AL_PATCHCODE        = 6
  #DTWAIN_AL_POWER            = 7
  #DTWAIN_AL_SKEW             = 8
  
  ;= #DTWAIN File System constants 
  #DTWAIN_FT_CAMERA        = 0
  #DTWAIN_FT_CAMERATOP     = 1
  #DTWAIN_FT_CAMERABOTTOM  = 2
  #DTWAIN_FT_CAMERAPREVIEW = 3
  #DTWAIN_FT_DOMAIN        = 4
  #DTWAIN_FT_HOST          = 5
  #DTWAIN_FT_DIRECTORY     = 6
  #DTWAIN_FT_IMAGE         = 7
  #DTWAIN_FT_UNKNOWN       = 8
  
  ;= #DTWAIN Noise Filter constants 
  #DTWAIN_NF_NONE          = 0
  #DTWAIN_NF_AUTO          = 1
  #DTWAIN_NF_LONEPIXEL     = 2
  #DTWAIN_NF_MAJORITYRULE  = 3
  
  ;= #DTWAIN Clear Buffers 
  #DTWAIN_CB_AUTO         = 0
  #DTWAIN_CB_CLEAR        = 1
  #DTWAIN_CB_NOCLEAR      = 2
  
  ;= #DTWAIN Feeder Alignment 
  #DTWAIN_FA_NONE         = 0
  #DTWAIN_FA_LEFT         = 1
  #DTWAIN_FA_CENTER       = 2
  #DTWAIN_FA_RIGHT        = 3
  
  ;= #DTWAIN Pixel Flavor 
  #DTWAIN_PF_CHOCOLATE    = 0
  #DTWAIN_PF_VANILLA      = 1
  
  ;= #DTWAIN Feeder Order 
  #DTWAIN_FO_FIRSTPAGEFIRST= 0
  #DTWAIN_FO_LASTPAGEFIRST = 1
  
  ;= #DTWAIN File increment flags 
  #DTWAIN_INCREMENT_STATIC  = 0
  #DTWAIN_INCREMENT_DYNAMIC = 1
  #DTWAIN_INCREMENT_DEFAULT = -1
  
  ;= #DTWAIN Manual Duplex mode constants 
  #DTWAIN_MANDUP_FACEUPTOPPAGE     = 0
  #DTWAIN_MANDUP_FACEUPBOTTOMPAGE  = 1
  #DTWAIN_MANDUP_FACEDOWNTOPPAGE   = 2
  #DTWAIN_MANDUP_FACEDOWNBOTTOMPAGE= 3
  
  #DTWAIN_FILESAVE_DEFAULT         = 0
  #DTWAIN_FILESAVE_UICLOSE         = 1
  #DTWAIN_FILESAVE_SOURCECLOSE     = 2
  #DTWAIN_FILESAVE_ENDACQUIRE      = 3
  #DTWAIN_FILESAVE_MANUALSAVE      = 4
  #DTWAIN_FILESAVE_SAVEINCOMPLETE  = 128
  
  #DTWAIN_MANDUP_SCANOK                   = 1 ; must be= 1 for proper processing 
  #DTWAIN_MANDUP_SIDE1RESCAN              = 2
  #DTWAIN_MANDUP_SIDE2RESCAN              = 3
  #DTWAIN_MANDUP_RESCANALL                = 4
  #DTWAIN_MANDUP_PAGEMISSING              = 5
  
  #DTWAIN_DEMODLL_VERSION                 = $00000001
  #DTWAIN_UNLICENSED_VERSION              = $00000002
  #DTWAIN_COMPANY_VERSION                 = $00000004
  #DTWAIN_GENERAL_VERSION                 = $00000008
  #DTWAIN_DEVELOP_VERSION                 = $00000010
  #DTWAIN_JAVA_VERSION                    = $00000020
  #DTWAIN_TOOLKIT_VERSION                 = $00000040
  #DTWAIN_LIMITEDDLL_VERSION              = $00000080
  #DTWAIN_STATICLIB_VERSION               = $00000100
  #DTWAIN_STATICLIB_STDCALL_VERSION       = $00000200
  #DTWAIN_PDF_VERSION                     = $00010000
  #DTWAIN_TWAINSAVE_VERSION               = $00020000
  #DTWAIN_OCR_VERSION                     = $00040000
  #DTWAIN_BARCODE_VERSION                 = $00080000
  #DTWAIN_ACTIVEX_VERSION                 = $00100000
  #DTWAIN_32BIT_VERSION                   = $00200000
  #DTWAIN_64BIT_VERSION                   = $00400000
  #DTWAIN_UNICODE_VERSION                 = $00800000
  #DTWAIN_OPENSOURCE_VERSION              = $01000000
  
  
  ; OCR defines 
  #DTWAINOCR_RETURNHANDLE                 = 1
  #DTWAINOCR_COPYDATA                     = 2
  
  #DTWAIN_OCRINFO_CHAR                    = 0
  #DTWAIN_OCRINFO_CHARXPOS                = 1
  #DTWAIN_OCRINFO_CHARYPOS                = 2
  #DTWAIN_OCRINFO_CHARXWIDTH              = 3
  #DTWAIN_OCRINFO_CHARYWIDTH              = 4
  #DTWAIN_OCRINFO_CHARCONFIDENCE          = 5
  #DTWAIN_OCRINFO_PAGENUM                 = 6
  #DTWAIN_OCRINFO_OCRENGINE               = 7
  #DTWAIN_OCRINFO_TEXTLENGTH              = 8
  
  #DTWAIN_PDFPAGETYPE_COLOR               = 0
  #DTWAIN_PDFPAGETYPE_BW                  = 1
  
  ; DSM types 
  #DTWAIN_TWAINDSM_LEGACY                 = 1
  #DTWAIN_TWAINDSM_VERSION2               = 2
  #DTWAIN_TWAINDSM_LATESTVERSION          = 4
  
  ; Windows TWAIN DSM search logic constants 
  #DTWAIN_TWAINDSMSEARCH_NOTFOUND         = (-1)
  #DTWAIN_TWAINDSMSEARCH_WSO              = 0
  #DTWAIN_TWAINDSMSEARCH_WOS              = 1
  #DTWAIN_TWAINDSMSEARCH_SWO              = 2
  #DTWAIN_TWAINDSMSEARCH_SOW              = 3
  #DTWAIN_TWAINDSMSEARCH_OWS              = 4
  #DTWAIN_TWAINDSMSEARCH_OSW              = 5
  #DTWAIN_TWAINDSMSEARCH_W                = 6
  #DTWAIN_TWAINDSMSEARCH_S                = 7
  #DTWAIN_TWAINDSMSEARCH_O                = 8
  #DTWAIN_TWAINDSMSEARCH_WS               = 9
  #DTWAIN_TWAINDSMSEARCH_WO               = 10
  #DTWAIN_TWAINDSMSEARCH_SW               = 11
  #DTWAIN_TWAINDSMSEARCH_SO               = 12
  #DTWAIN_TWAINDSMSEARCH_OW               = 13
  #DTWAIN_TWAINDSMSEARCH_OS               = 14
  #DTWAIN_TWAINDSMSEARCH_C                = 15
  
  #DTWAIN_PDFPOLARITY_POSITIVE            = 1
  #DTWAIN_PDFPOLARITY_NEGATIVE            = 2
  
  ; CAP_PRINTERFONTSTYLE 
  #DTWAIN_TWPF_NORMAL             = 0
  #DTWAIN_TWPF_BOLD               = 1
  #DTWAIN_TWPF_ITALIC             = 2
  #DTWAIN_TWPF_LARGESIZE          = 3
  #DTWAIN_TWPF_SMALLSIZE          = 4
  
  ; CAP_PRINTERINDEXTRIGGER Added= 2.3 
  #DTWAIN_TWCT_PAGE               = 0
  #DTWAIN_TWCT_PATCH1             = 1
  #DTWAIN_TWCT_PATCH2             = 2
  #DTWAIN_TWCT_PATCH3             = 3
  #DTWAIN_TWCT_PATCH4             = 4
  #DTWAIN_TWCT_PATCH5             = 5
  #DTWAIN_TWCT_PATCH6             = 6
  
  ; CAP_DOUBLEFEED... 
  #DTWAIN_TWDF_ULTRASONIC         = 0
  #DTWAIN_TWDF_BYLENGTH           = 1
  #DTWAIN_TWDF_INFRARED           = 2
  
  ;= #DTWAIN Twain name lookup constants 
  #DTWAIN_CONSTANT_TWPT    = 0
  #DTWAIN_CONSTANT_TWUN    = 1
  #DTWAIN_CONSTANT_TWCY    = 2
  #DTWAIN_CONSTANT_TWAL    = 3
  #DTWAIN_CONSTANT_TWAS    = 4
  #DTWAIN_CONSTANT_TWBCOR  = 5
  #DTWAIN_CONSTANT_TWBD    = 6
  #DTWAIN_CONSTANT_TWBO    = 7
  #DTWAIN_CONSTANT_TWBP    = 8
  #DTWAIN_CONSTANT_TWBR    = 9
  #DTWAIN_CONSTANT_TWBT    = 10
  #DTWAIN_CONSTANT_TWCP    = 11
  #DTWAIN_CONSTANT_TWCS    = 12
  #DTWAIN_CONSTANT_TWDE    = 13
  #DTWAIN_CONSTANT_TWDR    = 14
  #DTWAIN_CONSTANT_TWDSK   = 15
  #DTWAIN_CONSTANT_TWDX    = 16
  #DTWAIN_CONSTANT_TWFA    = 17   
  #DTWAIN_CONSTANT_TWFE    = 18   
  #DTWAIN_CONSTANT_TWFF    = 19
  #DTWAIN_CONSTANT_TWFL    = 20   
  #DTWAIN_CONSTANT_TWFO    = 21  
  #DTWAIN_CONSTANT_TWFP    = 22   
  #DTWAIN_CONSTANT_TWFR    = 23   
  #DTWAIN_CONSTANT_TWFT    = 24   
  #DTWAIN_CONSTANT_TWFY    = 22   
  #DTWAIN_CONSTANT_TWIA    = 23   
  #DTWAIN_CONSTANT_TWIC    = 27   
  #DTWAIN_CONSTANT_TWIF    = 28   
  #DTWAIN_CONSTANT_TWIM    = 29   
  #DTWAIN_CONSTANT_TWJC    = 30   
  #DTWAIN_CONSTANT_TWJQ    = 31   
  #DTWAIN_CONSTANT_TWLP    = 32   
  #DTWAIN_CONSTANT_TWLS    = 33   
  #DTWAIN_CONSTANT_TWMD    = 34  
  #DTWAIN_CONSTANT_TWNF    = 35  
  #DTWAIN_CONSTANT_TWOR    = 36  
  #DTWAIN_CONSTANT_TWOV    = 37  
  #DTWAIN_CONSTANT_TWPA    = 38  
  #DTWAIN_CONSTANT_TWPC    = 39  
  #DTWAIN_CONSTANT_TWPCH   = 40  
  #DTWAIN_CONSTANT_TWPF    = 41  
  #DTWAIN_CONSTANT_TWPM    = 42  
  #DTWAIN_CONSTANT_TWPR    = 43  
  #DTWAIN_CONSTANT_TWPF2   = 44  
  #DTWAIN_CONSTANT_TWCT    = 45  
  #DTWAIN_CONSTANT_TWPS    = 46  
  #DTWAIN_CONSTANT_TWSS    = 47  
  #DTWAIN_CONSTANT_LAST    = (#DTWAIN_CONSTANT_TWSS + 1)
  
  
  
  
  ; DTWAIN File Types.  Use only If Source does Not support File Transfer, 
  ; or if you want to acquire using DTWAIN's file mode
  #DTWAIN_BMP          = 100   ; Windows BMP file 
  #DTWAIN_JPEG         = 200   ; JPEG - See DTWAIN_SetJPEGQuality  
  
  #DTWAIN_PDF          = 250   ; Adobe Acrobat PDF File 
  #DTWAIN_PDFMULTI     = 251   ; Multi-page PDF file 
  
  #DTWAIN_PCX          = 300   ; ZSoft file 
  #DTWAIN_DCX          = 301   ; Multi-page PCX file 
  #DTWAIN_TGA          = 400   ; TARGA 
  #DTWAIN_TIFFLZW      = 500   ; TIFF With LZW compression 
  #DTWAIN_TIFFNONE     = 600   ; Uncompressed TIFF 
  #DTWAIN_TIFFG3       = 700   ; Group 3 CCITT Tiff (FAX format) 
  #DTWAIN_TIFFG4       = 800   ; Group 4 CCITT Tiff (FAX format) 
  #DTWAIN_TIFFPACKBITS = 801   ; Huffman encoded Tiff 
  #DTWAIN_TIFFDEFLATE  = 802   ; TIFF packed With z-lib encoded Data
  #DTWAIN_TIFFJPEG     = 803   ; See DTWAIN_SetJPEGQuality  
  #DTWAIN_TIFFJBIG     = 804   ; TIFF-JBIG compression (Not implemented due To patent) 
  #DTWAIN_TIFFPIXARLOG = 805   ; TIFF Pixar Log compression (Not implemented )
  #DTWAIN_TIFFNONEMULTI  = 900 ; Multi-page TIFF, No compression by Default 
  #DTWAIN_TIFFG3MULTI    = 901 ; Multi-page TIFF, Group 3 
  #DTWAIN_TIFFG4MULTI    = 902 ; Multi-page TIFF, Group 4 
  #DTWAIN_TIFFPACKBITSMULTI  = 903   ; Multi-page TIFF, Huffman encoded 
  #DTWAIN_TIFFDEFLATEMULTI   = 904   ; Multi-pageTIFF, zlib compression 
  #DTWAIN_TIFFJPEGMULTI   = 905      ; Multi-pageTIFF, JPEG compression 
  #DTWAIN_TIFFLZWMULTI = 906         ; Multi-page TIFF, LZW compression 
  #DTWAIN_TIFFJBIGMULTI = 907        ; Multi-page TIFF, JBIG compression (Not implememted due To patent) 
  #DTWAIN_TIFFPIXARLOGMULTI = 908    ; Multi-page TIFF Pixar Log compression (Not implemented )
  #DTWAIN_WMF          = 850         ; Windows meta-file 
  #DTWAIN_EMF          = 851         ; Enhanced Windows meta-file 
  #DTWAIN_GIF          = 950         ; GIF Format 
  #DTWAIN_PNG          = 1000        ; Portable Network Graphics 
  #DTWAIN_PSD          = 2000        ; Adobe Photoshop PSD file 
  #DTWAIN_JPEG2000     = 3000        ; JPEG-2000 file 
  #DTWAIN_POSTSCRIPT1  = 4000        ; Postscript Level 1 
  #DTWAIN_POSTSCRIPT2  = 4001        ; Postscript Level 2 
  #DTWAIN_POSTSCRIPT3  = 4002        ; Postscript Level 3 
  #DTWAIN_POSTSCRIPT1MULTI  = 4003   ; Postscript Level 1 Multipage 
  #DTWAIN_POSTSCRIPT2MULTI  = 4004   ; Postscript Level 2 Multipage 
  #DTWAIN_POSTSCRIPT3MULTI  = 4005   ; Postscript Level 3 Multipage 
  #DTWAIN_TEXT              = 6000   ; Text file produced from OCR 
  #DTWAIN_TEXTMULTI         = 6001   ; Multi-page text file 
  #DTWAIN_TIFFMULTI         = 7000   ; Only To be used For standalone OCR engines 
  #DTWAIN_ICO               = 8000   ; Windows ICO (icon) format 
  #DTWAIN_ICO_VISTA         = 8001   ; Windows ICO (icon) format For Vista And above OS 
  #DTWAIN_WBMP              = 8500   ; Wireless Bitmap (WAP) format 
  #DTWAIN_WEBP              = 8501   ; Google webp format 
  #DTWAIN_PCD               = 9000   ; Kodak PCD 
  #DTWAIN_PBM               = 10000  ; Portable bitmap
  #DTWAIN_PPM               = #DTWAIN_PBM ; Portable bitmap
  
  
  
  ; PDF Text options 

; Which page To print text 

; Start of DTWAIN constant definitions 
#DTWAIN_PDFTEXT_ALLPAGES      = $00000001
#DTWAIN_PDFTEXT_EVENPAGES     = $00000002
#DTWAIN_PDFTEXT_ODDPAGES      = $00000004
#DTWAIN_PDFTEXT_FIRSTPAGE     = $00000008
#DTWAIN_PDFTEXT_LASTPAGE      = $00000010
#DTWAIN_PDFTEXT_CURRENTPAGE   = $00000020
#DTWAIN_PDFTEXT_DISABLED      = $00000040  ; text is ignored

; Where To print the text (overrides absolute coordinates) 
#DTWAIN_PDFTEXT_TOPLEFT       = $00000100
#DTWAIN_PDFTEXT_TOPRIGHT      = $00000200
#DTWAIN_PDFTEXT_HORIZCENTER   = $00000400
#DTWAIN_PDFTEXT_VERTCENTER    = $00000800
#DTWAIN_PDFTEXT_BOTTOMLEFT    = $00001000
#DTWAIN_PDFTEXT_BOTTOMRIGHT   = $00002000
#DTWAIN_PDFTEXT_BOTTOMCENTER  = $00004000
#DTWAIN_PDFTEXT_TOPCENTER     = $00008000
#DTWAIN_PDFTEXT_XCENTER       = $00010000
#DTWAIN_PDFTEXT_YCENTER       = $00020000

; Which parameters To use when calling DTWAIN_AddPDFText 
#DTWAIN_PDFTEXT_NOSCALING     = $00100000
#DTWAIN_PDFTEXT_NOCHARSPACING = $00200000
#DTWAIN_PDFTEXT_NOWORDSPACING = $00400000
#DTWAIN_PDFTEXT_NOSTROKEWIDTH = $00800000
#DTWAIN_PDFTEXT_NORENDERMODE  = $01000000
#DTWAIN_PDFTEXT_NORGBCOLOR    = $02000000
#DTWAIN_PDFTEXT_NOFONTSIZE    = $04000000
#DTWAIN_PDFTEXT_NOABSPOSITION = $08000000
#DTWAIN_PDFTEXT_IGNOREALL     = $FFF00000

#DTWAIN_FONT_COURIER              = 0
#DTWAIN_FONT_COURIERBOLD          = 1
#DTWAIN_FONT_COURIERBOLDOBLIQUE   = 2
#DTWAIN_FONT_COURIEROBLIQUE       = 3
#DTWAIN_FONT_HELVETICA            = 4
#DTWAIN_FONT_HELVETICABOLD        = 5
#DTWAIN_FONT_HELVETICABOLDOBLIQUE = 6
#DTWAIN_FONT_HELVETICAOBLIQUE     = 7
#DTWAIN_FONT_TIMESBOLD            = 8
#DTWAIN_FONT_TIMESBOLDITALIC      = 9
#DTWAIN_FONT_TIMESROMAN           = 10
#DTWAIN_FONT_TIMESITALIC          = 11
#DTWAIN_FONT_SYMBOL               = 12
#DTWAIN_FONT_ZAPFDINGBATS         = 13

; Render modes 
#DTWAIN_PDFRENDER_FILL       = 0
#DTWAIN_PDFRENDER_STROKE     = 1
#DTWAIN_PDFRENDER_FILLSTROKE = 2
#DTWAIN_PDFRENDER_INVISIBLE  = 3  ; the text exists, but is Not visible

; Text element 
#DTWAIN_PDFTEXTELEMENT_SCALINGXY      = 0
#DTWAIN_PDFTEXTELEMENT_FONTHEIGHT     = 1
#DTWAIN_PDFTEXTELEMENT_WORDSPACING    = 2
#DTWAIN_PDFTEXTELEMENT_POSITION       = 3
#DTWAIN_PDFTEXTELEMENT_COLOR          = 4
#DTWAIN_PDFTEXTELEMENT_STROKEWIDTH    = 5
#DTWAIN_PDFTEXTELEMENT_DISPLAYFLAGS   = 6
#DTWAIN_PDFTEXTELEMENT_FONTNAME       = 7
#DTWAIN_PDFTEXTELEMENT_TEXT           = 8
#DTWAIN_PDFTEXTELEMENT_RENDERMODE     = 9
#DTWAIN_PDFTEXTELEMENT_CHARSPACING    = 10
#DTWAIN_PDFTEXTELEMENT_ROTATIONANGLE  = 11
#DTWAIN_PDFTEXTELEMENT_LEADING        = 12
#DTWAIN_PDFTEXTELEMENT_SCALING        = 13
#DTWAIN_PDFTEXTELEMENT_TEXTLENGTH     = 14
#DTWAIN_PDFTEXTELEMENT_SKEWANGLES     = 15
#DTWAIN_PDFTEXTELEMENT_TRANSFORMORDER = 16

; Text transformations 
#DTWAIN_PDFTEXTTRANSFORM_TSRK       = 0
#DTWAIN_PDFTEXTTRANSFORM_TSKR       = 1
#DTWAIN_PDFTEXTTRANSFORM_TKSR       = 2
#DTWAIN_PDFTEXTTRANSFORM_TKRS       = 3
#DTWAIN_PDFTEXTTRANSFORM_TRSK       = 4
#DTWAIN_PDFTEXTTRANSFORM_TRKS       = 5

#DTWAIN_PDFTEXTTRANSFORM_STRK       = 6
#DTWAIN_PDFTEXTTRANSFORM_STKR       = 7
#DTWAIN_PDFTEXTTRANSFORM_SKTR       = 8
#DTWAIN_PDFTEXTTRANSFORM_SKRT       = 9
#DTWAIN_PDFTEXTTRANSFORM_SRTK       = 10
#DTWAIN_PDFTEXTTRANSFORM_SRKT       = 11

#DTWAIN_PDFTEXTTRANSFORM_RSTK       = 12
#DTWAIN_PDFTEXTTRANSFORM_RSKT       = 13
#DTWAIN_PDFTEXTTRANSFORM_RTSK       = 14
#DTWAIN_PDFTEXTTRANSFORM_RTKT       = 15
#DTWAIN_PDFTEXTTRANSFORM_RKST       = 16
#DTWAIN_PDFTEXTTRANSFORM_RKTS       = 17

#DTWAIN_PDFTEXTTRANSFORM_KSTR       = 18
#DTWAIN_PDFTEXTTRANSFORM_KSRT       = 19
#DTWAIN_PDFTEXTTRANSFORM_KRST       = 20
#DTWAIN_PDFTEXTTRANSFORM_KRTS       = 21
#DTWAIN_PDFTEXTTRANSFORM_KTSR       = 22
#DTWAIN_PDFTEXTTRANSFORM_KTRS       = 23

#DTWAIN_PDFTEXTTRANFORM_LAST        = #DTWAIN_PDFTEXTTRANSFORM_KTRS

  
  
  
  
  
  Prototype.l Prototype_DTWAIN_AcquireBuffered(Source.l, PixelType.l, NumPages.l, bShowUI.l, bCloseSource.l, *pStatus.Long)
  Global AcquireBuffered.Prototype_DTWAIN_AcquireBuffered
  
  Prototype.l Prototype_DTWAIN_AcquireBufferedEx(Source.l, PixelType.l, NumPages.l, bShowUI.l, bCloseSource.l, *Acquisitions, *pStatus.Long)
  Global AcquireBufferedEx.Prototype_DTWAIN_AcquireBufferedEx
  
  Prototype.l Prototype_DTWAIN_AcquireFile(Source.l, lpszFile.p-Unicode, lFileType.l , lFileFlags.l, PixelType.l, lMaxPages.l, bShowUI.l, bCloseSource.l, *pStatus.Long)
  Global AcquireFile.Prototype_DTWAIN_AcquireFile
  
  Prototype.l Prototype_DTWAIN_AcquireFileEx(Source.l, *FileNames, FileType.l, FileControlFlag.l, PixelType.l, NumPages.l, bShowUI.l, bCloseSource.l, *pStatus.Long)
  Global AcquireFileEx.Prototype_DTWAIN_AcquireFileEx
  
  Prototype.l Prototype_DTWAIN_AcquireNative(Source.l, PixelType.l, NumPages.l, bShowUI.l, bCloseSource.l, *pStatus.long)
  Global AcquireNative.Prototype_DTWAIN_AcquireNative
  
  Prototype.l Prototype_DTWAIN_AcquireNativeEx(Source.l, PixelType.l, NumPages.l, bShowUI.l, bCloseSource.l, *Acquisitions, *pStatus.Long)
  Global AcquireNativeEx.Prototype_DTWAIN_AcquireNativeEx
  
  Prototype.l Prototype_DTWAIN_AcquireToClipboard(Source.l, PixelType.l, NumPages.l, TransferMode.l, bDiscardImages.l, bShowUI.l, bCloseSource.l, *pStatus.Long)
  Global AcquireToClipboard.Prototype_DTWAIN_AcquireToClipboard
  
  Prototype.l Prototype_DTWAIN_AddPDFText(Source.l, szText.p-Unicode, xPos.l, yPos.l, szFontName.p-Unicode, fontHeight.l, fontRGBColor.l, renderMode.l, scaling.f, charSpacing.f, wordSpacing.f, strokeWidth.l, displayFlags.l)
  Global AddPDFText.Prototype_DTWAIN_AddPDFText
  
  Prototype.l Prototype_DTWAIN_ArrayAdd(*Array, *pValue.long)
  Global ArrayAdd.Prototype_DTWAIN_ArrayAdd 
  
  Prototype.l Prototype_DTWAIN_ArrayAddFloat(*Array, Value.f)
  Global ArrayAddFloat.Prototype_DTWAIN_ArrayAddFloat
  
  Prototype.l Prototype_DTWAIN_ArrayAddLong(*Array, Value.l)
  Global ArrayAddLong.Prototype_DTWAIN_ArrayAddLong
  
  Prototype.l Prototype_DTWAIN_ArrayAddLong64(*Array, Value.q)
  Global ArrayAddLong64.Prototype_DTWAIN_ArrayAddLong64
  
  Prototype.l Prototype_DTWAIN_ArrayAddANSIString(*Array, Value.p-Unicode)
  Global ArrayAddANSIString.Prototype_DTWAIN_ArrayAddANSIString
  
  Prototype.l Prototype_DTWAIN_ArrayAddString(*Array, Value.p-Unicode)
  Global ArrayAddString.Prototype_DTWAIN_ArrayAddString
  
  Prototype.l Prototype_DTWAIN_ArrayDestroy(*Array)
  Global ArrayDestroy.Prototype_DTWAIN_ArrayDestroy
  
  Prototype.l Prototype_DTWAIN_ArrayGetAt(*Array, Index.l, *pValue.Long)
  Global ArrayGetAt.Prototype_DTWAIN_ArrayGetAt
  
  Prototype.l Prototype_DTWAIN_ArrayGetCount(*Array)
  Global ArrayGetCount.Prototype_DTWAIN_ArrayGetCount
  
  Prototype.l Prototype_DTWAIN_EnableMsgNotify(bEnable.l)
  Global EnableMsgNotify.Prototype_DTWAIN_EnableMsgNotify
  
  Prototype.l Prototype_DTWAIN_EnumSources(lpArray)
  Global EnumSources.Prototype_DTWAIN_EnumSources
  
  Prototype.l Prototype_DTWAIN_GetAcquiredImage(*AcqArray, WhichAcquire.l, WhichImage.l)
  Global GetAcquiredImage.Prototype_DTWAIN_GetAcquiredImage
  
  Prototype.l Prototype_DTWAIN_GetSourceProductName(Source.l, *szBuffer, Maxlen.l)
  Global GetSourceProductName.Prototype_DTWAIN_GetSourceProductName
  
  Prototype.l Prototype_DTWAIN_IsTwainAvailable()
  Global IsTwainAvailable.Prototype_DTWAIN_IsTwainAvailable
  
  Prototype.l Prototype_DTWAIN_LogMessage(lpszMessage.p-Unicode)
  Global LogMessage.Prototype_DTWAIN_LogMessage
  
  Prototype.l Prototype_DTWAIN_SelectDefaultSource()
  Global SelectDefaultSource.Prototype_DTWAIN_SelectDefaultSource
  
  Prototype.l Prototype_DTWAIN_SelectSource()
  Global SelectSource.Prototype_DTWAIN_SelectSource
  
  Prototype.l Prototype_DTWAIN_SelectSource2(hWndParent.l, szTitle.p-Unicode, xpos.l, ypos.l, flags.l)
  Global SelectSource2.Prototype_DTWAIN_SelectSource2
  
  Prototype.l Prototype_DTWAIN_SelectSourceByName(szName.p-Unicode)
  Global SelectSourceByName.Prototype_DTWAIN_SelectSourceByName
  
  Prototype.l DTWAIN_CALLBACK_PROC(wParam.u, lParam.l, UserData.l)
  Prototype.l Prototype_DTWAIN_SetCallback(lProc.DTWAIN_CALLBACK_PROC, UserData.l)
  Global SetCallback.Prototype_DTWAIN_SetCallback
  
  Prototype.l Prototype_DTWAIN_SetCompressionType(Source.l, Compression.l, bSetCurrent.l)
  Global SetCompressionType.Prototype_DTWAIN_SetCompressionType
  
  Prototype.l Prototype_DTWAIN_SetTwainLog(LogFlags.l, lpszFile.p-Unicode)
  Global SetTwainLog.Prototype_DTWAIN_SetTwainLog
  
  Prototype.l Prototype_DTWAIN_SetTwainMode(TwainMode.l)
  Global SetTwainMode.Prototype_DTWAIN_SetTwainMode
  
  Prototype.l Prototype_DTWAIN_SysDestroy()
  Global SysDestroy.Prototype_DTWAIN_SysDestroy
  
  Prototype.l Prototype_DTWAIN_SysInitialize()
  Global SysInitialize.Prototype_DTWAIN_SysInitialize
  
  
  Library.i
  
  Declare.i Open()
  Declare.i Close()
  
EndDeclareModule


Module DTWAIN
  
  Procedure.i Open()
    
    CompilerIf #PB_Compiler_32Bit
      Library = OpenLibrary(#PB_Any, "dtwain32u.dll") ; u means unicode version
    CompilerElse
      Library = OpenLibrary(#PB_Any, "dtwain64u.dll")
    CompilerEndIf
    If Library
      AcquireBuffered = GetFunction(Library, "DTWAIN_AcquireBuffered")
      AcquireBufferedEx = GetFunction(Library, "DTWAIN_AcquireBufferedEx")
      AcquireFile = GetFunction(Library, "DTWAIN_AcquireFile")
      AcquireFileEx = GetFunction(Library, "DTWAIN_AcquireFileEx")
      AcquireNative = GetFunction(Library, "DTWAIN_AcquireNative")
      AcquireNativeEx = GetFunction(Library, "DTWAIN_AcquireNativeEx")
      AcquireToClipboard = GetFunction(Library, "DTWAIN_AcquireToClipboard")
      AddPDFText = GetFunction(Library, "DTWAIN_AddPDFText")
      ArrayAdd = GetFunction(Library, "DTWAIN_ArrayAdd")
      ArrayAddFloat = GetFunction(Library, "DTWAIN_ArrayAddFloat")
      ArrayAddLong = GetFunction(Library, "DTWAIN_ArrayAddLong")
      ArrayAddLong64 = GetFunction(Library, "DTWAIN_ArrayAddLong64")
      ArrayAddANSIString = GetFunction(Library, "DTWAIN_ArrayAddANSIString")
      ArrayAddString = GetFunction(Library, "DTWAIN_ArrayAddString")
      ArrayDestroy = GetFunction(Library, "DTWAIN_ArrayDestroy")
      ArrayGetAt = GetFunction(Library, "DTWAIN_ArrayGetAt")
      ArrayGetCount = GetFunction(Library, "DTWAIN_ArrayGetCount")
      EnableMsgNotify = GetFunction(Library, "DTWAIN_EnableMsgNotify")
      EnumSources = GetFunction(Library, "DTWAIN_EnumSources")
      GetAcquiredImage = GetFunction(Library, "DTWAIN_GetAcquiredImage")
      GetSourceProductName = GetFunction(Library, "DTWAIN_GetSourceProductName")
      IsTwainAvailable = GetFunction(Library, "DTWAIN_IsTwainAvailable")
      LogMessage = GetFunction(Library, "DTWAIN_LogMessage")
      SelectDefaultSource = GetFunction(Library, "DTWAIN_SelectDefaultSource")
      SelectSource = GetFunction(Library, "DTWAIN_SelectSource")
      SelectSource2 = GetFunction(Library, "DTWAIN_SelectSource2")
      SelectSourceByName = GetFunction(Library, "DTWAIN_SelectSourceByName")
      SetCallback = GetFunction(Library, "DTWAIN_SetCallback")
      SetCompressionType = GetFunction(Library, "DTWAIN_SetCompressionType")
      SetTwainLog = GetFunction(Library, "DTWAIN_SetTwainLog")
      SetTwainMode = GetFunction(Library, "DTWAIN_SetTwainMode")
      SysDestroy = GetFunction(Library, "DTWAIN_SysDestroy")
      SysInitialize = GetFunction(Library, "DTWAIN_SysInitialize")
    EndIf
    
    ProcedureReturn Library
    
  EndProcedure
  
  
  Procedure.i Close()
    
    If IsLibrary(Library)
      CloseLibrary(Library)
      Library = 0
    EndIf
    
  EndProcedure
  
EndModule



CompilerIf #PB_Compiler_IsMainFile
  
  Define.i i, Count, *StringBuffer
  Define.l Source, Status, hDIB
  Define *Array, *Acquisitions
  
  
  If DTWAIN::Open()
    Debug "DTWAIN library open"
    
;     If DTWAIN::SetTwainLog(DTWAIN::#DTWAIN_LOG_ALL, GetPathPart(ProgramFilename()) + "DTWAIN.log")
;       Debug "Logging enabled"
;     Else
;       Debug "Logging not possible"
;     EndIf
    
    If DTWAIN::IsTwainAvailable()
      Debug "TWAIN available"
      
      If DTWAIN::SysInitialize()
        Debug "Initialzized"
        
        ; works first after SysInitialize()
        If DTWAIN::LogMessage("DTWAIN for PureBasic")
          Debug "Logging Ok"
        Else
          Debug "Logging not possible"
        EndIf
        
        DTWAIN::SetTwainMode(DTWAIN::#DTWAIN_MODAL) ; that's the default
        
        If DTWAIN::EnumSources(@*Array)
          Debug "Enum Ok"
          Count = DTWAIN::ArrayGetCount(*Array)
          Debug Count
          
          For i = 0 To Count - 1
            DTWAIN::ArrayGetAt(*Array, i, @Source)
            *StringBuffer = AllocateMemory(256)
            If *StringBuffer
              If DTWAIN::GetSourceProductName(Source, *StringBuffer, MemorySize(*StringBuffer))
                Debug Str(i + 1) + ": " + PeekS(*StringBuffer)
              EndIf
              FreeMemory(*StringBuffer)
            EndIf
          Next i
          
          DTWAIN::ArrayDestroy(*Array)
        EndIf
        
        ;Source = DTWAIN::SelectDefaultSource()
        ;Source = DTWAIN::SelectSourceByName("source")
        ;Source = DTWAIN::SelectSource()
        Source = DTWAIN::SelectSource2(#Null, "PB choose a source", 100, 100, DTWAIN::#DTWAIN_DLG_SORTNAMES)
        If Source
          
          *StringBuffer = AllocateMemory(256)
          If *StringBuffer
            If DTWAIN::GetSourceProductName(Source, *StringBuffer, MemorySize(*StringBuffer))
              Debug "Selected source: " + PeekS(*StringBuffer)
            EndIf
            FreeMemory(*StringBuffer)
          EndIf
          
          DTwain::AcquireFile(Source, "c:\\tmp\\test.bmp", DTWAIN::#DTWAIN_BMP, DTWAIN::#DTWAIN_USENATIVE|DTwain::#DTWAIN_USENAME, DTWAIN::#DTWAIN_PT_RGB, 1, #True, #True, @Status)
          
          *Acquisitions = DTwain::AcquireNative(Source, DTWAIN::#DTWAIN_PT_RGB, 1, #True, #True, @Status)
          If *Acquisitions
            hDIB = DTWAIN::GetAcquiredImage(*Acquisitions, 0, 0)
            Debug hDIB
          EndIf
          
          If DTWAIN::AcquireToClipboard(Source, DTWAIN::#DTWAIN_PT_DEFAULT, 1, DTWAIN::#DTWAIN_USENATIVE, #True, #True, #True, @Status) = 1
            Debug "Scan is in Clipboard"
          Else
            Debug "Status: " + Status
          EndIf
          
          DTWAIN::SysDestroy()
        EndIf
      EndIf
      
      DTWAIN::Close()
    Else
      Debug "TWAIN not installed"
    EndIf
  Else
    Debug "Was not able to open the DTWAIN library"
  EndIf
  
CompilerEndIf

; IDE Options = PureBasic 6.02 beta 3 LTS (Windows - x86)
; CursorPosition = 3424
; FirstLine = 3380
; Folding = --
; EnableXP
; CompileSourceDirectory